/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.APIDeployer;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.rest.API;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.rest.api.APIException;
import org.wso2.carbon.rest.api.ConfigHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

public class APIServiceComponent {
    private static final Log log = LogFactory.getLog(APIServiceComponent.class);
    private boolean activated = false;

    protected void activate(ComponentContext ctxt) {
        try {
            SynapseEnvironmentService synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(-1234);
            this.registerDeployer(ConfigHolder.getInstance().getAxisConfiguration(), synEnvService.getSynapseEnvironment());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Rest API Admin bundle is activated ");
            }
            this.activated = true;
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Rest API Admin bundle ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        try {
            Set<Map.Entry<Integer, SynapseEnvironmentService>> entrySet = ConfigHolder.getInstance().getSynapseEnvironmentServices().entrySet();
            for (Map.Entry<Integer, SynapseEnvironmentService> entry : entrySet) {
                this.unregisterDeployer(entry.getValue().getConfigurationContext().getAxisConfiguration(), entry.getValue().getSynapseEnvironment());
            }
        }
        catch (APIException e) {
            log.warn((Object)"Couldn't remove the APIDeployer");
        }
    }

    private void unregisterDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) throws APIException {
        if (axisConfig != null) {
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
            String apiDirPath = synapseConfigPath + File.separator + "api";
            deploymentEngine.removeDeployer(apiDirPath, "xml");
        }
    }

    private void registerDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) throws APIException {
        SynapseConfiguration synCfg = synapseEnvironment.getSynapseConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synCfg.getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
        String apiDirPath = synapseConfigPath + File.separator + "api";
        for (API api : synCfg.getAPIs()) {
            if (api.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(apiDirPath + File.separator + api.getFileName());
        }
        deploymentEngine.addDeployer((Deployer)new APIDeployer(), apiDirPath, "xml");
    }

    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(null);
    }

    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(synapseConfigurationService.getSynapseConfiguration());
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(null);
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        boolean alreadyCreated = ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(synapseEnvironmentService.getTenantId());
        ConfigHolder.getInstance().addSynapseEnvironmentService(synapseEnvironmentService.getTenantId(), synapseEnvironmentService);
        if (this.activated && !alreadyCreated) {
            try {
                this.registerDeployer(synapseEnvironmentService.getConfigurationContext().getAxisConfiguration(), synapseEnvironmentService.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rest API bundle is activated ");
                }
            }
            catch (Throwable e) {
                log.error((Object)"Failed to activate Rest API Admin bundle ", e);
            }
        }
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseEnvironmentService.getTenantId());
    }

    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the restapi component");
        }
        try {
            ConfigHolder.getInstance().setConfigRegistry(regService.getConfigSystemRegistry());
            ConfigHolder.getInstance().setGovernanceRegistry(regService.getGovernanceSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the restapi component");
        }
        ConfigHolder.getInstance().setConfigRegistry(null);
    }

    protected void setDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service bound to the restapi component");
        }
        ConfigHolder.getInstance().setDependencyManager(dependencyMgr);
    }

    protected void unsetDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service unbound from the restapi component");
        }
        ConfigHolder.getInstance().setDependencyManager(null);
    }

    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        int tenantId = synapseRegistrationsService.getTenantId();
        if (ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(tenantId)) {
            SynapseEnvironment env = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId).getSynapseEnvironment();
            ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseRegistrationsService.getTenantId());
            AxisConfiguration axisConfig = synapseRegistrationsService.getConfigurationContext().getAxisConfiguration();
            if (axisConfig != null) {
                try {
                    this.unregisterDeployer(axisConfig, env);
                }
                catch (APIException e) {
                    log.warn((Object)"Couldn't remove the APIDeployer");
                }
            }
        }
    }
}

