/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.util.commons;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import org.wso2.carbon.reporting.api.ReportingException;

public class XmlDataSource {
    public JRDataSource getJRDataSourceFromXml(String filePath) throws ReportingException {
        JRXmlDataSource jrXmlDataSource;
        try {
            FileInputStream inputStream = new FileInputStream(new File(filePath));
            jrXmlDataSource = new JRXmlDataSource((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            throw new ReportingException(filePath + " file could not found");
        }
        catch (JRException e) {
            throw new ReportingException("could not create JRXmlDataSource from " + filePath);
        }
        return jrXmlDataSource;
    }

    public JRDataSource getJRDataSourceFromString(String xmlAsString) throws ReportingException {
        JRXmlDataSource jrXmlDataSourceFromString;
        byte[] bytes = xmlAsString.getBytes();
        try {
            jrXmlDataSourceFromString = new JRXmlDataSource((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (JRException e) {
            throw new ReportingException("could not create JRXmlDataSource from " + xmlAsString);
        }
        return jrXmlDataSourceFromString;
    }
}

