/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapArrayDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.util.Column;
import org.wso2.carbon.reporting.util.OMElementHandler;
import org.wso2.carbon.reporting.util.ReportDataSource;
import org.wso2.carbon.reporting.util.ReportParamMap;
import org.wso2.carbon.reporting.util.Row;

public class JasperPrintProvider {
    Log log = LogFactory.getLog(JasperPrintProvider.class);

    public JasperPrint createJasperPrint(Object dataSource, String template, ReportParamMap[] reportParamMap) throws JRException, ReportingException {
        JasperPrint jasperPrint;
        block6: {
            byte[] templateBytes = template.getBytes();
            ByteArrayInputStream templateInputStream = new ByteArrayInputStream(templateBytes);
            try {
                HashMap map;
                JasperDesign jasperDesign = JRXmlLoader.load((InputStream)templateInputStream);
                JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                try {
                    map = this.getParamMap(reportParamMap, template);
                }
                catch (ReportingException e) {
                    throw new ReportingException("Failed to get report param map", (Throwable)e);
                }
                if (dataSource instanceof JRDataSource) {
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)map, (JRDataSource)((JRDataSource)dataSource));
                    break block6;
                }
                if (dataSource instanceof Connection) {
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)map, (Connection)((Connection)dataSource));
                    break block6;
                }
                this.log.error((Object)"data source is not a JDBC connection or JRDataSource");
                return null;
            }
            catch (JRException e) {
                this.log.error((Object)e);
                throw new JRException("JasperPrint creation failed from ", (Throwable)e);
            }
        }
        return jasperPrint;
    }

    public JasperPrint createJasperPrint(ReportDataSource dataSource, String template, ReportParamMap[] parametersMap, String[] subRepNames, String[] subReportTemplates) throws JRException, ReportingException {
        JasperPrint jasperPrint;
        byte[] templateBytes = template.getBytes();
        ByteArrayInputStream templateInputStream = new ByteArrayInputStream(templateBytes);
        Object jrDataSource = null;
        jrDataSource = dataSource == null ? new JREmptyDataSource() : this.getJRDataSource(dataSource);
        try {
            HashMap map;
            try {
                map = this.getParamMap(parametersMap, template);
            }
            catch (ReportingException e) {
                throw new ReportingException("Failed to get report param map", (Throwable)e);
            }
            if (subReportTemplates != null) {
                int i = 0;
                for (String aSubTemplate : subReportTemplates) {
                    ByteArrayInputStream subInputStream = new ByteArrayInputStream(aSubTemplate.getBytes());
                    JasperDesign jasperDesign = JRXmlLoader.load((InputStream)subInputStream);
                    JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                    this.log.info((Object)"Sub Report compilation completed..");
                    map.put(subRepNames[i], jasperReport);
                    ++i;
                }
            }
            JasperDesign jasperDesign = JRXmlLoader.load((InputStream)templateInputStream);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            this.log.info((Object)"Report compilation completed..");
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)map, (JRDataSource)jrDataSource);
            this.log.info((Object)"Report filling is completed..");
        }
        catch (JRException e) {
            this.log.error((Object)e);
            throw new JRException("JasperPrint creation failed from ", (Throwable)e);
        }
        return jasperPrint;
    }

    private HashMap getParamMap(ReportParamMap[] reportParamMap, String template) throws ReportingException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, String> reportParams = new HashMap<String, String>();
        if (reportParamMap.length > 0) {
            try {
                OMElement omElement = OMElementHandler.createOMElement(template);
                Iterator iterator = omElement.getChildrenWithName(new QName("parameter"));
                while (iterator.hasNext()) {
                    OMElement paramOmElement = (OMElement)iterator.next();
                    String classValue = paramOmElement.getAttribute(new QName("class")).getAttributeValue();
                    String name = paramOmElement.getAttribute(new QName("name")).getAttributeValue();
                    reportParams.put(name, classValue);
                }
            }
            catch (ReportingException e) {
                throw new ReportingException("Failed to generate OmElement from template ", (Throwable)e);
            }
            for (ReportParamMap paramMap : reportParamMap) {
                String key = paramMap.getParamKey();
                String value = paramMap.getParamValue();
                ReportDataSource reportDataSource = paramMap.getDataSource();
                String type = (String)reportParams.get(key);
                if (key == null || !(value != null | reportDataSource != null) || type == null) continue;
                if (type.equals("java.lang.String")) {
                    hashMap.put(key, value);
                    continue;
                }
                if (type.equals("java.lang.Integer")) {
                    hashMap.put(key, Integer.parseInt(value));
                    continue;
                }
                if (type.equals("java.lang.Float")) {
                    hashMap.put(key, Float.valueOf(Float.parseFloat(value)));
                    continue;
                }
                if (type.equals("java.lang.Double")) {
                    hashMap.put(key, Double.parseDouble(value));
                    continue;
                }
                if (type.equals("java.lang.Boolean")) {
                    hashMap.put(key, Boolean.parseBoolean(value));
                    continue;
                }
                if (type.equals("java.lang.Short")) {
                    hashMap.put(key, Short.parseShort(value));
                    continue;
                }
                if (type.equals("java.lang.Long")) {
                    hashMap.put(type, Long.parseLong(value));
                    continue;
                }
                if (type.equals("java.util.Date")) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyy");
                    try {
                        Date convertedDate = dateFormat.parse(value);
                        Timestamp timeStampDate = new Timestamp(convertedDate.getTime());
                        hashMap.put(key, timeStampDate);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type.equals("java.sql.Timestamp")) {
                    hashMap.put(key, Timestamp.valueOf(value));
                    continue;
                }
                if (type.equals("java.sql.Time")) {
                    hashMap.put(type, Time.valueOf(value));
                    continue;
                }
                if (type.equals("java.math.BigDecimal")) {
                    hashMap.put(key, new BigDecimal(value));
                    continue;
                }
                if (type.equals("net.sf.jasperreports.engine.JRDataSource")) {
                    if (paramMap.getDataSource() != null) {
                        JRDataSource dataSource = this.getJRDataSource(paramMap.getDataSource());
                        hashMap.put(key, dataSource);
                        continue;
                    }
                    throw new ReportingException("No Data source found in parameters map");
                }
                this.log.warn((Object)("This data type not support : " + type));
            }
        }
        return hashMap;
    }

    private JRDataSource getJRDataSource(ReportDataSource dataSource) {
        Object[] reportRows = new HashMap[dataSource.getRows().length];
        Row[] rows = dataSource.getRows();
        for (int i = 0; i < rows.length; ++i) {
            Column[] columns;
            Row row = rows[i];
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Column aColumn : columns = row.getColumns()) {
                String key = aColumn.getKey();
                String value = aColumn.getValue();
                String type = aColumn.getType();
                if (key == null || value == null) continue;
                if (type.equals("java.lang.String")) {
                    hashMap.put(key, value);
                    continue;
                }
                if (type.equals("java.lang.Integer")) {
                    hashMap.put(key, Integer.parseInt(value));
                    continue;
                }
                if (type.equals("java.lang.Float")) {
                    hashMap.put(key, Float.valueOf(Float.parseFloat(value)));
                    continue;
                }
                if (type.equals("java.lang.Double")) {
                    hashMap.put(key, Double.parseDouble(value));
                    continue;
                }
                if (type.equals("java.lang.Boolean")) {
                    hashMap.put(key, Boolean.parseBoolean(value));
                    continue;
                }
                if (type.equals("java.lang.Short")) {
                    hashMap.put(key, Short.parseShort(value));
                    continue;
                }
                if (type.equals("java.lang.Long")) {
                    hashMap.put(type, Long.parseLong(value));
                    continue;
                }
                if (type.equals("java.util.Date")) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyy");
                    try {
                        Date convertedDate = dateFormat.parse(value);
                        Timestamp timeStampDate = new Timestamp(convertedDate.getTime());
                        hashMap.put(key, timeStampDate);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type.equals("java.sql.Timestamp")) {
                    hashMap.put(key, Timestamp.valueOf(value));
                    continue;
                }
                if (type.equals("java.sql.Time")) {
                    hashMap.put(type, Time.valueOf(value));
                    continue;
                }
                if (type.equals("java.math.BigDecimal")) {
                    hashMap.put(key, new BigDecimal(value));
                    continue;
                }
                this.log.warn((Object)("This data type not support : " + type));
            }
            reportRows[i] = hashMap;
        }
        JRMapArrayDataSource jrDataSource = new JRMapArrayDataSource(reportRows);
        return jrDataSource;
    }
}

