/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.ui.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.ui.BeanCollectionReportData;
import org.wso2.carbon.reporting.ui.client.ReportResourceSupplierClient;
import org.wso2.carbon.reporting.util.JasperPrintProvider;
import org.wso2.carbon.reporting.util.ReportParamMap;
import org.wso2.carbon.reporting.util.ReportStream;
import org.wso2.carbon.ui.CarbonUIUtil;

public class BeanCollectionReportServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(BeanCollectionReportServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ReportingException {
        Object reportDataObject;
        String component = request.getParameter("component");
        String template = request.getParameter("template");
        String type = request.getParameter("type");
        String reportData = request.getParameter("reportDataSession");
        String downloadFileName = null;
        if (component == null || template == null || type == null || reportData == null) {
            throw new ReportingException("required one or more parameters missing (component ,template , reportType, reportData)");
        }
        if (type.equals("pdf")) {
            response.setContentType("application/pdf");
            downloadFileName = template + ".pdf";
        } else if (type.equals("excel")) {
            response.setContentType("application/vnd.ms-excel");
            downloadFileName = template + ".xls";
        } else if (type.equals("html")) {
            response.setContentType("text/html");
        } else {
            throw new ReportingException("requested report type can not be support");
        }
        if (downloadFileName != null) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + downloadFileName + "\"");
        }
        if ((reportDataObject = request.getSession().getAttribute(reportData)) == null) {
            throw new ReportingException("can't generate report , data unavailable in session ");
        }
        try {
            String serverURL = CarbonUIUtil.getServerURL((ServletContext)request.getSession().getServletContext(), (HttpSession)request.getSession());
            ConfigurationContext configurationContext = (ConfigurationContext)request.getSession().getServletContext().getAttribute("ConfigurationContext");
            String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
            ReportResourceSupplierClient resourceSupplierClient = new ReportResourceSupplierClient(cookie, serverURL, configurationContext);
            String reportResource = resourceSupplierClient.getReportResources(component, template);
            JRDataSource jrDataSource = new BeanCollectionReportData().getReportDataSource(reportDataObject);
            JasperPrintProvider jasperPrintProvider = new JasperPrintProvider();
            JasperPrint jasperPrint = jasperPrintProvider.createJasperPrint((Object)jrDataSource, reportResource, new ReportParamMap[0]);
            request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
            ReportStream reportStream = new ReportStream();
            ByteArrayOutputStream outputStream = reportStream.getReportStream(jasperPrint, type);
            ServletOutputStream servletOutputStream = response.getOutputStream();
            try {
                outputStream.writeTo((OutputStream)servletOutputStream);
                outputStream.flush();
            }
            finally {
                outputStream.close();
                servletOutputStream.close();
            }
        }
        catch (Exception e) {
            String msg = "Error occurred handling " + template + "report request from " + component;
            this.log(msg);
            throw new ReportingException(msg, (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(BeanCollectionReportServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(BeanCollectionReportServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to generate report from ben collection";
    }
}

