/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.template.ui.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.template.ui.client.ReportTemplateClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ReportGenerator
extends HttpServlet {
    private static Log log = LogFactory.getLog(ReportGenerator.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String errorString = "";
        ReportTemplateClient client = new ReportTemplateClient(configContext, serverURL, cookie);
        String reportName = request.getParameter("reportName");
        String reportType = request.getParameter("reportType");
        String downloadFileName = null;
        if (reportType.equals("pdf")) {
            response.setContentType("application/pdf");
            downloadFileName = reportName + ".pdf";
        } else if (reportType.equals("xls")) {
            response.setContentType("application/vnd.ms-excel");
            downloadFileName = reportName + ".xls";
        } else if (reportType.equals("html")) {
            response.setContentType("text/html");
        }
        if (downloadFileName != null) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + downloadFileName + "\"");
        }
        DataHandler dataHandler = null;
        if (client != null) {
            dataHandler = client.generateReport(reportName, reportType);
        }
        ServletOutputStream outputStream = response.getOutputStream();
        if (dataHandler != null) {
            dataHandler.writeTo((OutputStream)outputStream);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to generate report from data source";
    }
}

