/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.template.ui.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.template.ui.client.ReportTemplateClient;
import org.wso2.carbon.reporting.template.ui.servlet.ReportGenerator;
import org.wso2.carbon.ui.CarbonUIUtil;

public class CompositeReportProcessor
extends HttpServlet {
    private static Log log = LogFactory.getLog(CompositeReportProcessor.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String webContext = (String)request.getAttribute("WebContext");
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String errorString = "";
        ReportTemplateClient client = new ReportTemplateClient(configContext, serverURL, cookie);
        String reportname = request.getParameter("reportName");
        String[] reports = this.getSubReportsName(request);
        if (reports != null) {
            client.addNewCompositeReport(reports, reportname);
            response.sendRedirect("../reporting_custom/list-reports.jsp?region=region5&item=reporting_list");
        } else {
            errorString = "No reports was sleected to form the composite report";
            request.setAttribute("errorString", (Object)errorString);
            response.sendRedirect("../reporting-template/add-composite-report.jsp");
        }
    }

    private String[] getSubReportsName(HttpServletRequest request) {
        String reportNo = request.getParameter("noReports");
        if (reportNo != null) {
            String[] reportIndex = reportNo.split(",");
            ArrayList<String> reports = new ArrayList<String>();
            for (String index : reportIndex) {
                String repName = request.getParameter("report_" + index);
                reports.add(repName);
            }
            String[] temp = new String[reports.size()];
            return reports.toArray(temp);
        }
        return null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to generate report from data source";
    }
}

