/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.custom.ui.upload;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.reporting.custom.ui.client.JrxmlFileUploaderClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class JrxmlFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".jrxml", ".xml"};
    private static Log log = LogFactory.getLog(JrxmlFileUploadExecutor.class);
    private String redirect;

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        boolean status = false;
        Map fileItemsMap = this.getFileItemsMap();
        Map formFieldsMap = this.getFormFieldsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/create-reports/list-reports.jsp"));
            return false;
        }
        JrxmlFileUploaderClient uploaderClient = new JrxmlFileUploaderClient(cookie, serverURL, this.configurationContext);
        List fileItems = (List)fileItemsMap.get("upload");
        String errorRedirect = null;
        try {
            for (FileItemData fileItem : fileItems) {
                String filename = this.getFileName(fileItem.getFileItem().getName());
                try {
                    this.checkServiceFileExtensionValidity(filename, ALLOWED_FILE_EXTENSIONS);
                }
                catch (FileUploadException e) {
                    log.error((Object)("Failed to validate format of file : " + filename), (Throwable)e);
                    throw e;
                }
                if (!filename.endsWith(".jrxml")) {
                    throw new CarbonException("File with extension " + this.getFileName(fileItem.getFileItem().getName()) + " is not supported!");
                }
                String uploadStatue = uploaderClient.uploadJrxmlFile(filename.split(".jrxml")[0], fileItem.getFileItem().getString());
                if (uploadStatue.equals("success")) {
                    status = true;
                }
                response.setContentType("text/html; charset=utf-8");
                String msg = "Successfully uploaded jrxml file.";
                if (this.redirect == null) {
                    CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request);
                    response.sendRedirect("../" + webContext + "/reporting_custom/list-reports.jsp?region=region5&item=reporting_list");
                    continue;
                }
                response.sendRedirect("../" + webContext + "/" + this.redirect);
            }
            return status;
        }
        catch (IOException e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            if (errorRedirect == null) {
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request);
                response.sendRedirect("../" + webContext + "/reporting_custom/list-reports.jsp");
            } else {
                response.sendRedirect("../" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
            }
            return false;
        }
        catch (RuntimeException e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            this.buildUIError(request, response, webContext, errorRedirect, msg);
            return false;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            this.buildUIError(request, response, webContext, errorRedirect, msg);
            return status;
        }
    }

    private void buildUIError(HttpServletRequest request, HttpServletResponse response, String webContext, String errorRedirect, String msg) throws IOException {
        CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
        if (errorRedirect == null) {
            response.sendRedirect("../" + webContext + "/admin/error.jsp");
        } else {
            response.sendRedirect("../" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
        }
    }
}

