/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.custom.ui.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.custom.ui.client.DBReportingServiceClient;
import org.wso2.carbon.reporting.stub.DBReportingService;
import org.wso2.carbon.reporting.stub.core.services.ReportBean;
import org.wso2.carbon.reporting.stub.core.services.ReportParamMap;
import org.wso2.carbon.ui.CarbonUIUtil;

public class BDReportServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(BDReportServlet.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] parmCollection;
        String dataSource = request.getParameter("dataSource");
        String reportName = request.getParameter("reportName");
        String reportType = request.getParameter("reportType");
        String params = request.getParameter("hidden_param");
        String downloadFileName = null;
        if (reportType.equals("pdf")) {
            response.setContentType("application/pdf");
            downloadFileName = reportName + ".pdf";
        } else if (reportType.equals("excel")) {
            response.setContentType("application/vnd.ms-excel");
            downloadFileName = reportName + ".xls";
        } else if (reportType.equals("html")) {
            response.setContentType("text/html");
        } else {
            throw new ReportingException("requested report type can not be support");
        }
        if (downloadFileName != null) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + downloadFileName + "\"");
        }
        ReportBean reportBean = new ReportBean();
        reportBean.setTemplateName(reportName);
        reportBean.setReportType(reportType);
        reportBean.setDataSourceName(dataSource);
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)request.getSession().getServletContext(), (HttpSession)request.getSession());
        ConfigurationContext configurationContext = (ConfigurationContext)request.getSession().getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        DBReportingServiceClient dbReportingServiceClient = null;
        try {
            dbReportingServiceClient = new DBReportingServiceClient(cookie, serverURL, configurationContext);
        }
        catch (AxisFault axisFault) {
            axisFault.printStackTrace();
        }
        ArrayList<ReportParamMap> reportParamMapsList = new ArrayList<ReportParamMap>();
        for (String inputParam : parmCollection = params.split("\\|")) {
            if (inputParam == null || "".equals(inputParam)) continue;
            ReportParamMap reportParamMap = new ReportParamMap();
            String[] input = inputParam.split("\\=");
            reportParamMap.setParamKey(input[0]);
            reportParamMap.setParamValue(input[1]);
            reportParamMapsList.add(reportParamMap);
        }
        try {
            DataHandler dataHandler = null;
            if (dbReportingServiceClient != null) {
                dataHandler = dbReportingServiceClient.getReport(reportBean, reportParamMapsList.toArray(new ReportParamMap[reportParamMapsList.size()]));
            }
            ServletOutputStream outputStream = response.getOutputStream();
            if (dataHandler != null) {
                dataHandler.writeTo((OutputStream)outputStream);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to handle report request ", (Throwable)e);
            throw e;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(DBReportingService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(DBReportingService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to generate report from data source";
    }
}

