/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.custom.ui.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.custom.ui.beans.FormParameters;
import org.wso2.carbon.reporting.stub.ReportingResourcesSupplierReportingExceptionException;
import org.wso2.carbon.reporting.stub.ReportingResourcesSupplierStub;
import org.wso2.carbon.reporting.stub.core.services.ReportParameters;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ReportResourceSupplierClient {
    ReportingResourcesSupplierStub stub;
    private static Log log = LogFactory.getLog(ReportResourceSupplierClient.class);

    public ReportResourceSupplierClient(String cookie, String backEndServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backEndServerURL + "ReportingResourcesSupplier";
        this.stub = new ReportingResourcesSupplierStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static ReportResourceSupplierClient getInstance(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new ReportResourceSupplierClient(cookie, backendServerURL, configContext);
    }

    public String getReportResources(String componentName, String reportTemplate) throws RemoteException, ReportingResourcesSupplierReportingExceptionException {
        return this.stub.getReportResources(componentName, reportTemplate);
    }

    public String[] getAllReports() throws Exception {
        String[] reports;
        try {
            reports = this.stub.getAllReports();
        }
        catch (Exception e) {
            log.error((Object)"Failed to get report list", (Throwable)e);
            throw e;
        }
        return reports;
    }

    public void deleteReportTemplate(String templateName) throws Exception {
        try {
            this.stub.deleteReportTemplate(templateName);
        }
        catch (Exception e) {
            log.error((Object)("Failed to delete report template : " + templateName), (Throwable)e);
            throw e;
        }
    }

    public boolean updateReport(HttpServletRequest request) throws Exception {
        boolean status;
        String payload = request.getParameter("payload");
        String fileName = request.getParameter("name");
        try {
            status = this.stub.updateReport(fileName, payload);
        }
        catch (Exception e) {
            log.error((Object)("Failed to update report template : " + fileName), (Throwable)e);
            throw e;
        }
        return status;
    }

    public FormParameters[] getReportParam(String reportName) throws Exception {
        ArrayList<FormParameters> formParametersList = new ArrayList<FormParameters>();
        try {
            ReportParameters[] parameters = this.stub.getReportParam(reportName);
            if (parameters != null) {
                for (ReportParameters reportParameters : parameters) {
                    FormParameters formParameters = new FormParameters();
                    formParameters.setFormName(reportParameters.getParamName());
                    formParameters.setFormValue(reportParameters.getParamValue());
                    formParametersList.add(formParameters);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get report parameters for " + reportName), (Throwable)e);
            throw e;
        }
        return formParametersList.toArray(new FormParameters[formParametersList.size()]);
    }
}

