/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.custom.ui.client;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.stub.JrxmlFileUploaderStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class JrxmlFileUploaderClient {
    JrxmlFileUploaderStub stub;
    private static Log log = LogFactory.getLog(JrxmlFileUploaderClient.class);

    public JrxmlFileUploaderClient(String cookie, String backEndServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backEndServerURL + "JrxmlFileUploader";
        this.stub = new JrxmlFileUploaderStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static JrxmlFileUploaderClient getInstance(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new JrxmlFileUploaderClient(cookie, backendServerURL, configContext);
    }

    public String uploadJrxmlFile(String fileName, String fileContent) throws Exception {
        String status;
        try {
            status = this.stub.uploadJrxmlFile(fileName, fileContent);
        }
        catch (Exception e) {
            log.error((Object)("Failed to upload template " + fileName), (Throwable)e);
            throw e;
        }
        return status;
    }
}

