/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.custom.ui.client;

import javax.activation.DataHandler;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.stub.DBReportingServiceStub;
import org.wso2.carbon.reporting.stub.core.services.ReportBean;
import org.wso2.carbon.reporting.stub.core.services.ReportParamMap;
import org.wso2.carbon.ui.CarbonUIUtil;

public class DBReportingServiceClient {
    DBReportingServiceStub stub;
    private static Log log = LogFactory.getLog(DBReportingServiceClient.class);

    public DBReportingServiceClient(String cookie, String backEndServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backEndServerURL + "DBReportingService";
        this.stub = new DBReportingServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static DBReportingServiceClient getInstance(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new DBReportingServiceClient(cookie, backendServerURL, configContext);
    }

    public DataHandler getReport(ReportBean reportBean, ReportParamMap[] reportParamMap) throws Exception {
        DataHandler dataHandler;
        try {
            dataHandler = this.stub.getReport(reportBean, reportParamMap);
        }
        catch (Exception e) {
            log.error((Object)"Failed to generate report", (Throwable)e);
            throw e;
        }
        return dataHandler;
    }

    public String[] getCarbonDataSourceNames() throws Exception {
        String[] dataSourceNames;
        try {
            dataSourceNames = this.stub.getCarbonDataSourceNames();
        }
        catch (Exception e) {
            log.error((Object)"Failed to get data sources list ", (Throwable)e);
            throw e;
        }
        return dataSourceNames;
    }
}

