/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.template.ui.upload;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.reporting.template.stub.ReportTemplateAdminReportingExceptionException;
import org.wso2.carbon.reporting.template.stub.ReportTemplateAdminStub;
import org.wso2.carbon.reporting.template.ui.client.ReportTemplateClient;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class reportUploadExecutor
extends AbstractFileUploadExecutor {
    private List<FileItemData> images;
    private ReportTemplateAdminStub.TableReportDTO tableReport;
    private ReportTemplateAdminStub.ChartReportDTO chartReport;
    private Map<String, ArrayList<String>> formFieldsMap;
    private ReportTemplateClient client;
    private String redirect;

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        try {
            this.init(request);
        }
        catch (Exception e) {
            throw new CarbonException("Error while initializing the upload table tableReport configuration", (Throwable)e);
        }
        String reportType = null;
        if (this.formFieldsMap.get("reportType") != null) {
            reportType = this.formFieldsMap.get("reportType").get(0);
        }
        try {
            if (reportType == null) {
                this.handleTableReport();
            } else {
                this.handleChartReport(reportType);
            }
            if (this.redirect == null) {
                response.sendRedirect("../" + webContext + "/reporting_custom/list-reports.jsp?region=region5&item=reporting_list");
            } else {
                response.sendRedirect("../" + webContext + "/" + this.redirect);
            }
            return true;
        }
        catch (ReportTemplateAdminReportingExceptionException e) {
            response.sendRedirect("../" + webContext + "/reporting-template/table-tableReport-format.jsp?success=false");
            return false;
        }
    }

    private void handleTableReport() throws ReportTemplateAdminReportingExceptionException, RemoteException {
        this.handleTableReportHeaderInformation();
        this.handleColumnFormat();
        this.client.addNewReport(this.tableReport);
    }

    private void handleChartReport(String reportType) throws ReportTemplateAdminReportingExceptionException, RemoteException {
        this.handleChartReportHeaderInformation(reportType);
        this.handleChartFormat();
        this.client.addNewReport(this.chartReport);
    }

    private void init(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        this.client = new ReportTemplateClient(configContext, serverURL, cookie);
        Map fileItemsMap = this.getFileItemsMap();
        this.formFieldsMap = this.getFormFieldsMap();
        this.images = (List)fileItemsMap.get("logo");
        String type = null;
        if (this.formFieldsMap.get("reportType") != null) {
            type = this.formFieldsMap.get("reportType").get(0);
        }
        if (type == null) {
            this.tableReport = (ReportTemplateAdminStub.TableReportDTO)session.getAttribute("table-report");
        } else {
            this.chartReport = (ReportTemplateAdminStub.ChartReportDTO)session.getAttribute("chart-report");
        }
    }

    private void handleLogo() throws ReportTemplateAdminReportingExceptionException {
        ReportTemplateAdminStub.ReportHeaderInformationDTO header = null;
        if (this.tableReport != null) {
            header = this.tableReport.getReportHeaderInformation();
        } else if (this.chartReport != null) {
            header = this.chartReport.getReportHeaderInformation();
        }
        if (this.images != null && this.images.size() > 0) {
            FileItemData image = this.images.get(0);
            if (image.getFileItem().getContentType().contains("image/")) {
                ReportTemplateAdminStub.Resource resource = new ReportTemplateAdminStub.Resource();
                resource.setDataHandler(image.getDataHandler());
                resource.setFileName(this.formFieldsMap.get("imageName").get(0));
                header.setLogo(resource);
            } else {
                throw new ReportTemplateAdminReportingExceptionException("Unsupported file format. Only Image can be uploaded here.");
            }
        }
    }

    private void handleTableReportHeaderInformation() throws ReportTemplateAdminReportingExceptionException {
        ReportTemplateAdminStub.ReportHeaderInformationDTO header = this.tableReport.getReportHeaderInformation();
        if (header == null) {
            header = new ReportTemplateAdminStub.ReportHeaderInformationDTO();
            this.tableReport.setReportHeaderInformation(header);
        }
        this.handleLogo();
        this.tableReport.setReportType("table_type_report");
        header.setTitle(this.formFieldsMap.get("reportTitle").get(0));
        this.tableReport.setBackgroundColour("#" + this.formFieldsMap.get("reportColor").get(0));
        header.setTitleFont(this.getFontStyle("reportHeader"));
    }

    private void handleChartReportHeaderInformation(String reportType) throws ReportTemplateAdminReportingExceptionException {
        ReportTemplateAdminStub.ReportHeaderInformationDTO header = this.chartReport.getReportHeaderInformation();
        if (header == null) {
            header = new ReportTemplateAdminStub.ReportHeaderInformationDTO();
            this.chartReport.setReportHeaderInformation(header);
        }
        this.handleLogo();
        this.chartReport.setReportType(reportType);
        header.setTitle(this.formFieldsMap.get("reportTitle").get(0));
        this.chartReport.setBackgroundColour("#" + this.formFieldsMap.get("reportColor").get(0));
        header.setTitleFont(this.getFontStyle("reportHeader"));
    }

    private ReportTemplateAdminStub.FontStyleDTO getFontStyle(String elementName) {
        ReportTemplateAdminStub.FontStyleDTO style = new ReportTemplateAdminStub.FontStyleDTO();
        style.setFontName(this.formFieldsMap.get("font" + elementName + "style").get(0));
        style.setFontSize(Integer.parseInt(this.formFieldsMap.get("font" + elementName + "size").get(0)));
        style.setFontColor("#" + this.formFieldsMap.get("font" + elementName + "color").get(0));
        style.setBackgroundColour("#" + this.formFieldsMap.get(elementName + "BgColor").get(0));
        style.setBold(this.isChecked(elementName + "Bold"));
        style.setItalic(this.isChecked(elementName + "Italic"));
        style.setStrikeThough(this.isChecked(elementName + "Strike"));
        style.setUnderLine(this.isChecked(elementName + "underline"));
        style.setAlignment(this.formFieldsMap.get(elementName + "Alignment").get(0));
        return style;
    }

    private boolean isChecked(String fieldString) {
        if (this.formFieldsMap.get("selectedCheckBox") != null) {
            String checkedBox = this.formFieldsMap.get("selectedCheckBox").get(0);
            if (checkedBox != null && !checkedBox.equalsIgnoreCase("")) {
                return checkedBox.contains(fieldString);
            }
            return false;
        }
        return false;
    }

    private void handleColumnFormat() {
        ReportTemplateAdminStub.ColumnDTO[] columns = this.tableReport.getColumns();
        ReportTemplateAdminStub.ColumnDTO[] orderedCol = new ReportTemplateAdminStub.ColumnDTO[columns.length];
        for (ReportTemplateAdminStub.ColumnDTO column : columns) {
            column.setColumnHeaderName(this.formFieldsMap.get("columnHeaderName" + column.getColumnName()).get(0));
            column.setColumnFooterName(this.formFieldsMap.get("columnFooterName" + column.getColumnName()).get(0));
            column.setColumHeader(this.getFontStyle(column.getColumnName() + "Header"));
            column.setColumnFooter(this.getFontStyle(column.getColumnName() + "Footer"));
            column.setTableCell(this.getFontStyle(column.getColumnName() + "DetailCell"));
            int index = Integer.parseInt(this.formFieldsMap.get("columnOrder" + column.getColumnName()).get(0));
            orderedCol[index - 1] = column;
        }
        this.tableReport.setColumns(orderedCol);
    }

    private void handleChartFormat() {
        this.chartReport.setChartBackColor("#" + this.formFieldsMap.get("chartBgColor").get(0));
        this.chartReport.setTitle(this.formFieldsMap.get("chartTitle").get(0));
        this.chartReport.setSubTitle(this.formFieldsMap.get("chartSubTitle").get(0));
        if (this.formFieldsMap.get("xDataLabel") != null) {
            this.chartReport.setXAxisLabel(this.formFieldsMap.get("xDataLabel").get(0));
        }
        if (this.formFieldsMap.get("yDataLabel") != null) {
            this.chartReport.setYAxisLabel(this.formFieldsMap.get("yDataLabel").get(0));
        }
    }
}

