/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.template.ui.servlet;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.reporting.template.stub.ReportTemplateAdminStub;
import org.wso2.carbon.reporting.template.ui.client.ReportTemplateClient;
import org.wso2.carbon.reporting.template.ui.servlet.ReportGenerator;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ChartDataProcessor
extends HttpServlet {
    private static Log log = LogFactory.getLog(ChartDataProcessor.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String webContext = (String)request.getAttribute("WebContext");
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String errorString = "";
        ReportTemplateClient client = new ReportTemplateClient(configContext, serverURL, cookie);
        String reportType = request.getParameter("reportType");
        String dsName = request.getParameter("datasource");
        String tableName = request.getParameter("tableName");
        String reportname = request.getParameter("reportName");
        ReportTemplateAdminStub.SeriesDTO[] series = this.getSeries(request);
        String msg = "";
        if (reportType.contains("xy")) {
            msg = client.isValidNumberAxis(reportType, dsName, tableName, this.getXAxisFields(series));
        }
        if (msg.equals("")) {
            msg = client.isValidNumberAxis(reportType, dsName, tableName, this.getYAxisFields(series));
        }
        if (msg.equals("")) {
            ReportTemplateAdminStub.ChartReportDTO chartReport = new ReportTemplateAdminStub.ChartReportDTO();
            chartReport.setReportType(reportType);
            chartReport.setReportName(reportname);
            chartReport.setDsName(dsName);
            chartReport = this.addSeries(series, chartReport);
            session.setAttribute("chart-report", (Object)chartReport);
            response.sendRedirect("../reporting-template/chart-report-format.jsp?reportType=" + reportType);
        } else {
            request.setAttribute("errorString", (Object)msg);
            response.sendRedirect("../reporting-template/add-chart-report.jsp?reportType=" + reportType + "&success=false");
        }
    }

    private ReportTemplateAdminStub.SeriesDTO[] getSeries(HttpServletRequest request) {
        String strSeriesNumber = request.getParameter("noSeries");
        Integer noOfSeries = Integer.parseInt(strSeriesNumber);
        String tableName = request.getParameter("tableName");
        ReportTemplateAdminStub.SeriesDTO[] allSeries = new ReportTemplateAdminStub.SeriesDTO[noOfSeries.intValue()];
        for (int i = 0; i < noOfSeries; ++i) {
            ReportTemplateAdminStub.SeriesDTO series = new ReportTemplateAdminStub.SeriesDTO();
            String name = request.getParameter("series_" + (i + 1) + "_name");
            if (name == null) {
                name = "";
            }
            series.setName(name);
            ReportTemplateAdminStub.DataDTO xData = new ReportTemplateAdminStub.DataDTO();
            xData.setDsTableName(tableName);
            String colname = request.getParameter("series_" + (i + 1) + "_xData");
            xData.setDsColumnName(colname);
            series.setXdata(xData);
            ReportTemplateAdminStub.DataDTO yData = new ReportTemplateAdminStub.DataDTO();
            yData.setDsTableName(tableName);
            colname = request.getParameter("series_" + (i + 1) + "_yData");
            yData.setDsColumnName(colname);
            series.setYdata(yData);
            allSeries[i] = series;
        }
        return allSeries;
    }

    private ReportTemplateAdminStub.ChartReportDTO addSeries(ReportTemplateAdminStub.SeriesDTO[] series, ReportTemplateAdminStub.ChartReportDTO chartReport) {
        for (ReportTemplateAdminStub.SeriesDTO aSeries : series) {
            chartReport.addCategorySeries(aSeries);
        }
        return chartReport;
    }

    private String[] getYAxisFields(ReportTemplateAdminStub.SeriesDTO[] serieses) {
        String[] yFields = new String[serieses.length];
        for (int i = 0; i < serieses.length; ++i) {
            yFields[i] = serieses[i].getYdata().getDsColumnName();
        }
        return yFields;
    }

    private String[] getXAxisFields(ReportTemplateAdminStub.SeriesDTO[] serieses) {
        String[] xFields = new String[serieses.length];
        for (int i = 0; i < serieses.length; ++i) {
            xFields[i] = serieses[i].getXdata().getDsColumnName();
        }
        return xFields;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(ReportGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to generate report from data source";
    }
}

