/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.template.ui.client;

import java.awt.GraphicsEnvironment;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.reporting.stub.ReportingResourcesSupplierStub;
import org.wso2.carbon.reporting.template.stub.ReportTemplateAdminReportingExceptionException;
import org.wso2.carbon.reporting.template.stub.ReportTemplateAdminStub;

public class ReportTemplateClient {
    private ReportTemplateAdminStub templateAdminStub;
    private ReportingResourcesSupplierStub resourceStub;

    public ReportTemplateClient(ConfigurationContext configCtx, String backendServerURL, String cookie) throws Exception {
        String serviceURL = backendServerURL + "ReportTemplateAdmin";
        this.templateAdminStub = new ReportTemplateAdminStub(configCtx, serviceURL);
        ServiceClient client = this.templateAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setProperty("enableMTOM", (Object)"true");
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        String resourceServiceURL = backendServerURL + "ReportingResourcesSupplier";
        this.resourceStub = new ReportingResourcesSupplierStub(configCtx, resourceServiceURL);
        client = this.resourceStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getDatasourceNames() throws AxisFault {
        try {
            return this.templateAdminStub.getAllDatasourceNames();
        }
        catch (RemoteException e) {
            throw new AxisFault("Unable to get the names of datasources available");
        }
        catch (ReportTemplateAdminReportingExceptionException e) {
            throw new AxisFault("Unable to get the names of datasources available");
        }
    }

    public String[] getTableNames(String dsName) throws AxisFault {
        try {
            return this.templateAdminStub.getTableNames(dsName);
        }
        catch (RemoteException e) {
            throw new AxisFault("Unable to retrive the table names from data source " + dsName);
        }
        catch (ReportTemplateAdminReportingExceptionException e) {
            throw new AxisFault("Unable to retrive the table names from data source " + dsName);
        }
    }

    public String[] getFieldNames(String dsName, String tableName) throws AxisFault {
        try {
            return this.templateAdminStub.getColumnNames(dsName, tableName);
        }
        catch (RemoteException e) {
            throw new AxisFault("Unable to retrieve the column information of table " + tableName + ", datasource " + dsName);
        }
        catch (ReportTemplateAdminReportingExceptionException e) {
            throw new AxisFault("Unable to retrieve the column information of table " + tableName + ", datasource " + dsName);
        }
    }

    public ReportTemplateAdminStub.TableReportDTO createTableDataInformation(String reportName, String dsName, String tableName, String fieldsStr, String primaryField) {
        String[] fields;
        ReportTemplateAdminStub.TableReportDTO tableReport = new ReportTemplateAdminStub.TableReportDTO();
        tableReport.setReportName(reportName);
        tableReport.setDsName(dsName);
        for (String field : fields = fieldsStr.split(",")) {
            field = field.trim();
            ReportTemplateAdminStub.ColumnDTO column = new ReportTemplateAdminStub.ColumnDTO();
            column.setColumnFamilyName(tableName);
            column.setColumnName(field);
            if (field.equalsIgnoreCase(primaryField)) {
                column.setPrimaryColumn(true);
            }
            tableReport.addColumns(column);
        }
        return tableReport;
    }

    public String[] getAvailableFontNames() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return e.getAvailableFontFamilyNames();
    }

    public String[] getAlignments() {
        String[] alignments = new String[]{"Left", "Center", "Right", "Justified"};
        return alignments;
    }

    public void addNewReport(ReportTemplateAdminStub.TableReportDTO report) throws ReportTemplateAdminReportingExceptionException, RemoteException {
        this.templateAdminStub.addNewTableReport(report);
    }

    public void addNewReport(ReportTemplateAdminStub.ChartReportDTO report) throws ReportTemplateAdminReportingExceptionException, RemoteException {
        this.templateAdminStub.addNewChartReport(report);
    }

    public String[] getReportTypes() {
        String[] types = new String[]{"pdf", "xls", "html"};
        return types;
    }

    public DataHandler generateReport(String reportName, String format) throws ReportTemplateAdminReportingExceptionException, RemoteException {
        return this.templateAdminStub.generateReport(reportName, format);
    }

    public String isValidNumberAxis(String chartType, String dsname, String tablename, String[] fields) throws ReportTemplateAdminReportingExceptionException, RemoteException {
        return this.templateAdminStub.validateFields(chartType, dsname, tablename, fields);
    }

    public void addNewCompositeReport(String[] reports, String compositeRepName) throws ReportTemplateAdminReportingExceptionException, RemoteException {
        this.templateAdminStub.addCompositeReport(reports, compositeRepName);
    }

    public String[] getAllTemplateFiles() throws ReportTemplateAdminReportingExceptionException {
        try {
            String[] reports = this.resourceStub.getAllReports();
            ArrayList<String> templateReports = new ArrayList<String>();
            for (String aReport : reports) {
                if (!this.isReportTemplate(aReport) || this.templateAdminStub.isCompositeReport(aReport)) continue;
                templateReports.add(aReport);
            }
            String[] temp = new String[templateReports.size()];
            return templateReports.toArray(temp);
        }
        catch (Exception e) {
            throw new ReportTemplateAdminReportingExceptionException(e.getMessage());
        }
    }

    public boolean isReportTemplate(String reportName) throws ReportTemplateAdminReportingExceptionException, RemoteException {
        return this.templateAdminStub.isReportExists(reportName);
    }
}

