/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.fill.JRTextMeasurerFactory;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;

public final class JRTextMeasurerUtil {
    public static final String PROPERTY_TEXT_MEASURER_FACTORY = "net.sf.jasperreports.text.measurer.factory";
    private static final JRSingletonCache<JRTextMeasurerFactory> cache = new JRSingletonCache<JRTextMeasurerFactory>(JRTextMeasurerFactory.class);

    public static JRTextMeasurer createTextMeasurer(JRCommonText text) {
        JRPropertiesHolder propertiesHolder = text instanceof JRPropertiesHolder ? (JRPropertiesHolder)((Object)text) : null;
        return JRTextMeasurerUtil.createTextMeasurer(text, propertiesHolder);
    }

    public static JRTextMeasurer createTextMeasurer(JRCommonText text, JRPropertiesHolder propertiesHolder) {
        JRTextMeasurerFactory factory = JRTextMeasurerUtil.getTextMeasurerFactory(propertiesHolder);
        return factory.createMeasurer(text);
    }

    public static JRTextMeasurerFactory getTextMeasurerFactory(JRPropertiesHolder propertiesHolder) {
        String factoryClass = JRTextMeasurerUtil.getTextMeasurerFactoryClass(propertiesHolder);
        try {
            return cache.getCachedInstance(factoryClass);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected static String getTextMeasurerFactoryClass(JRPropertiesHolder propertiesHolder) {
        String factory = JRProperties.getProperty(propertiesHolder, PROPERTY_TEXT_MEASURER_FACTORY);
        String factoryClassProperty = "net.sf.jasperreports.text.measurer.factory." + factory;
        String factoryClass = JRProperties.getProperty(propertiesHolder, factoryClassProperty);
        if (factoryClass == null) {
            factoryClass = factory;
        }
        return factoryClass;
    }

    private JRTextMeasurerUtil() {
    }
}

