/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfArrayDataSource
implements JRRewindableDataSource {
    private List<Object[]> records = new ArrayList<Object[]>();
    private Iterator<Object[]> iterator;
    private Object[] currentRecord;
    private Map<String, Integer> columnNamesMap = new HashMap<String, Integer>();

    public ListOfArrayDataSource(List<Object[]> records, String[] columnNames) {
        this.records = records;
        if (columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNamesMap.put(columnNames[i], i);
            }
        }
        this.iterator = records.iterator();
    }

    @Override
    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRecord = this.iterator.next();
        }
        return hasNext;
    }

    @Override
    public Object getFieldValue(JRField jrField) {
        Integer fieldIndex = this.columnNamesMap.get(jrField.getName());
        if (fieldIndex == null) {
            throw new JRRuntimeException("Field \"" + jrField.getName() + "\" not found in data source.");
        }
        return this.currentRecord[fieldIndex];
    }

    @Override
    public void moveFirst() {
        this.iterator = this.records.iterator();
    }
}

