/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.SimpleFileResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JasperFillManager {
    public static String fillReportToFile(String sourceFileName, Map<String, Object> params, Connection connection) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, connection);
        return destFileName;
    }

    public static String fillReportToFile(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters);
        return destFileName;
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map<String, Object> params, Connection connection) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, connection);
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, connection);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public static JasperPrint fillReport(String sourceFileName, Map<String, Object> params, Connection connection) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        return JasperFillManager.fillReport(jasperReport, parameters, connection);
    }

    public static JasperPrint fillReport(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        return JasperFillManager.fillReport(jasperReport, parameters);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        JasperFillManager.fillReportToStream(jasperReport, outputStream, parameters, connection);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        JasperFillManager.fillReportToStream(jasperReport, outputStream, parameters);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, connection);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return JasperFillManager.fillReport(jasperReport, parameters, connection);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map<String, Object> parameters) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return JasperFillManager.fillReport(jasperReport, parameters);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, Connection connection) throws JRException {
        return JRFiller.fillReport(jasperReport, parameters, connection);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        return JRFiller.fillReport(jasperReport, parameters);
    }

    public static String fillReportToFile(String sourceFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, dataSource);
        return destFileName;
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, dataSource);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, dataSource);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public static JasperPrint fillReport(String sourceFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        return JasperFillManager.fillReport(jasperReport, parameters, dataSource);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        JasperFillManager.fillReportToStream(jasperReport, outputStream, parameters, dataSource);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, dataSource);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return JasperFillManager.fillReport(jasperReport, parameters, dataSource);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        return JRFiller.fillReport(jasperReport, parameters, dataSource);
    }

    protected static Map<String, Object> setFileResolver(File file, Map<String, Object> params) {
        Map<String, Object> parameters = params;
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        if (!parameters.containsKey("REPORT_FILE_RESOLVER")) {
            SimpleFileResolver fileResolver = new SimpleFileResolver(Arrays.asList(file.getParentFile(), new File(".")));
            fileResolver.setResolveAbsolutePath(true);
            parameters.put("REPORT_FILE_RESOLVER", fileResolver);
        }
        return parameters;
    }

    private JasperFillManager() {
    }
}

