/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.fill.JRFillXySeries;
import net.sf.jasperreports.charts.util.XYDatasetLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRFillXyDataset
extends JRFillChartDataset
implements JRXyDataset {
    protected JRFillXySeries[] xySeries;
    private List<Comparable<?>> seriesNames;
    private Map<Comparable<?>, XYSeries> seriesMap;
    private Map<Comparable<?>, Map<Number, String>> labelsMap;
    private Map<Comparable<?>, Map<Pair, JRPrintHyperlink>> itemHyperlinks;

    public JRFillXyDataset(JRXyDataset xyDataset, JRFillObjectFactory factory) {
        super(xyDataset, factory);
        JRXySeries[] srcXySeries = xyDataset.getSeries();
        if (srcXySeries != null && srcXySeries.length > 0) {
            this.xySeries = new JRFillXySeries[srcXySeries.length];
            for (int i = 0; i < this.xySeries.length; ++i) {
                this.xySeries[i] = (JRFillXySeries)factory.getXySeries(srcXySeries[i]);
            }
        }
    }

    @Override
    public JRXySeries[] getSeries() {
        return this.xySeries;
    }

    @Override
    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    @Override
    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i = 0; i < this.xySeries.length; ++i) {
                this.xySeries[i].evaluate(calculator);
            }
        }
    }

    @Override
    protected void customIncrement() {
        if (this.xySeries != null && this.xySeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i = 0; i < this.xySeries.length; ++i) {
                JRFillXySeries crtXySeries = this.xySeries[i];
                Comparable<?> seriesName = crtXySeries.getSeries();
                XYSeries xySrs = this.seriesMap.get(seriesName);
                if (xySrs == null) {
                    xySrs = new XYSeries(seriesName);
                    this.seriesNames.add(seriesName);
                    this.seriesMap.put(seriesName, xySrs);
                }
                xySrs.addOrUpdate(crtXySeries.getXValue(), crtXySeries.getYValue());
                if (crtXySeries.getLabelExpression() != null) {
                    Map<Number, String> seriesLabels = this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap<Number, String>();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put(crtXySeries.getXValue(), crtXySeries.getLabel());
                }
                if (!crtXySeries.hasItemHyperlinks()) continue;
                Map<Pair, JRPrintHyperlink> seriesLinks = this.itemHyperlinks.get(seriesName);
                if (seriesLinks == null) {
                    seriesLinks = new HashMap<Pair, JRPrintHyperlink>();
                    this.itemHyperlinks.put(seriesName, seriesLinks);
                }
                Pair<Number, Number> xyKey = new Pair<Number, Number>(crtXySeries.getXValue(), crtXySeries.getYValue());
                seriesLinks.put(xyKey, crtXySeries.getPrintItemHyperlink());
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        if (this.seriesNames != null) {
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                Comparable<?> seriesName = this.seriesNames.get(i);
                dataset.addSeries(this.seriesMap.get(seriesName));
            }
        }
        return dataset;
    }

    @Override
    public byte getDatasetType() {
        return 3;
    }

    @Override
    public Object getLabelGenerator() {
        return new XYDatasetLabelGenerator(this.labelsMap);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Map<Comparable<?>, Map<Pair, JRPrintHyperlink>> getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i = 0; i < this.xySeries.length && !foundLinks; ++i) {
                JRFillXySeries serie = this.xySeries[i];
                foundLinks = serie.hasItemHyperlinks();
            }
        }
        return foundLinks;
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

