/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.reporting.api.ReportingException;

public class ImageLoader {
    private ArrayList<String> imageNames;
    private String directory = "repository/resources/reporting/images";

    public void loadTempImages(String templateName, String jrxmlContent) throws ReportingException {
        this.imageNames = this.getImageNames(jrxmlContent);
        for (String imageName : this.imageNames) {
            String imagePath = this.directory + "/" + templateName + "_" + imageName;
            this.copyImagesToHome(imagePath, imageName);
        }
    }

    public boolean saveImage(String imageName, String reportName, DataHandler imageContent) {
        boolean success = true;
        boolean exists = new File(this.directory).exists();
        if (!exists) {
            success = new File(this.directory).mkdirs();
        }
        if (success) {
            File destFile = new File(this.directory + "/" + reportName + "_" + imageName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(destFile);
                imageContent.writeTo((OutputStream)fos);
                fos.flush();
                fos.close();
                success = true;
            }
            catch (FileNotFoundException e) {
                success = false;
            }
            catch (IOException e) {
                success = false;
            }
        }
        return success;
    }

    private ArrayList<String> getImageNames(String jrxmlContent) throws ReportingException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(jrxmlContent.getBytes());
            XMLInputFactory xif = XMLInputFactory.newInstance();
            XMLStreamReader reader = null;
            reader = xif.createXMLStreamReader(is);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement docElement = builder.getDocumentElement();
            AXIOMXPath xpathExpression = new AXIOMXPath("//a:title//a:band//a:image//a:imageExpression");
            xpathExpression.addNamespace("a", "http://jasperreports.sourceforge.net/jasperreports");
            List nodeList = xpathExpression.selectNodes((Object)docElement);
            ArrayList<String> imageNames = new ArrayList<String>();
            for (int i = 0; i < nodeList.size(); ++i) {
                OMElement element = (OMElement)nodeList.get(i);
                String imageName = element.getText();
                if (imageName == null || imageName.equalsIgnoreCase("")) continue;
                String imageText = imageName.replaceAll("\"", "");
                imageNames.add(imageText);
            }
            return imageNames;
        }
        catch (XMLStreamException e) {
            throw new ReportingException(e.getMessage(), (Throwable)e);
        }
        catch (JaxenException e) {
            throw new ReportingException(e.getMessage(), (Throwable)e);
        }
    }

    private void copyImagesToHome(String imagePath, String imageName) throws ReportingException {
        File src = new File(imagePath);
        File destFile = new File(imageName);
        FileChannel source = null;
        FileChannel destination = null;
        try {
            destFile.createNewFile();
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            long count = 0L;
            long size = source.size();
            while ((count += destination.transferFrom(source, 0L, size - count)) < size) {
            }
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        catch (IOException e) {
            throw new ReportingException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteTempImages() {
        for (String imageName : this.imageNames) {
            File file = new File(imageName);
            file.delete();
        }
    }
}

