/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.reporting.api.ReportingException;

public class CommonUtil {
    private static Log log = LogFactory.getLog(CommonUtil.class);

    public static void deleteReportTemplate(String templateName, Registry registry) throws ReportingException {
        try {
            if (registry.resourceExists("/repository/reports/org.wso2.carbon.reporting/")) {
                registry.delete("/repository/reports/org.wso2.carbon.reporting/" + templateName + ".jrxml");
            } else if (log.isDebugEnabled()) {
                log.info((Object)("no any report templates called " + templateName + " , to delete"));
            }
        }
        catch (RegistryException e) {
            throw new ReportingException("Error occurred deleting the report template : " + templateName, (Throwable)e);
        }
    }

    public static List<String> getAllReports(Registry registry) throws ReportingException {
        ArrayList<String> reportNames = null;
        try {
            if (registry.resourceExists("/repository/reports/org.wso2.carbon.reporting/")) {
                Resource resource = registry.get("/repository/reports/org.wso2.carbon.reporting/");
                if (resource instanceof Collection) {
                    String[] paths;
                    reportNames = new ArrayList<String>();
                    for (String resourcePath : paths = ((Collection)resource).getChildren()) {
                        Resource childResource = registry.get(resourcePath);
                        if (childResource instanceof Collection) continue;
                        String name = ((ResourceImpl)childResource).getName();
                        reportNames.add(name.split(".jrxml")[0]);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.info((Object)"no any report templates available to generate reports");
            }
        }
        catch (RegistryException e) {
            throw new ReportingException("Error occurred getting all the reports names", (Throwable)e);
        }
        return reportNames;
    }

    public static String getReportResources(String componentName, String reportTemplate, Registry registry) throws ReportingException, XMLStreamException {
        InputStream reportDefinitionOmStream;
        String jrXmlPath = componentName != null ? "/repository/reports/org.wso2.carbon.reporting/" + componentName + "/" + reportTemplate + ".jrxml" : "/repository/reports/org.wso2.carbon.reporting/" + reportTemplate + ".jrxml";
        try {
            Resource resource = registry.get(jrXmlPath);
            reportDefinitionOmStream = resource.getContentStream();
        }
        catch (RegistryException e) {
            throw new ReportingException(reportTemplate + " getting  failed from " + componentName, (Throwable)e);
        }
        XMLStreamReader xmlStreamReader = null;
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(reportDefinitionOmStream);
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xmlStreamReader);
            OMElement reportJrXmlOmElement = stAXOMBuilder.getDocumentElement();
            String string = reportJrXmlOmElement.toString();
            return string;
        }
        catch (XMLStreamException e) {
            throw new ReportingException(reportTemplate + " getting  failed from " + componentName, (Throwable)e);
        }
        finally {
            if (xmlStreamReader != null) {
                xmlStreamReader.close();
            }
        }
    }

    public static String getJRXMLFileContent(String componentName, String reportTemplate, Registry registry) throws ReportingException {
        String jrXmlPath = componentName != null ? "/repository/reports/org.wso2.carbon.reporting/" + componentName + "/" + reportTemplate + ".jrxml" : "/repository/reports/org.wso2.carbon.reporting/" + reportTemplate + ".jrxml";
        try {
            String line;
            Resource resource = registry.get(jrXmlPath);
            InputStream reportDefinitionOmStream = resource.getContentStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(reportDefinitionOmStream));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            return sb.toString();
        }
        catch (RegistryException e) {
            throw new ReportingException(reportTemplate + " getting  failed from " + componentName, (Throwable)e);
        }
        catch (IOException e) {
            throw new ReportingException(reportTemplate + " failed to read");
        }
    }

    public static boolean updateReport(String fileName, String fileContent, Registry registry) throws ReportingException, JRException {
        boolean status;
        try {
            try {
                byte[] fileContentBytes = fileContent.getBytes();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContentBytes);
                JRXmlLoader.load((InputStream)inputStream);
            }
            catch (JRException e) {
                throw new JRException("This is not valid report template", (Throwable)e);
            }
            Resource reportFilesResource = registry.newResource();
            reportFilesResource.setContent((Object)fileContent);
            registry.put("/repository/reports/org.wso2.carbon.reporting/" + fileName + ".jrxml", reportFilesResource);
            status = true;
        }
        catch (RegistryException e) {
            throw new ReportingException("Failed to update report template " + fileName, (Throwable)e);
        }
        return status;
    }
}

