/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import net.sf.jasperreports.engine.JRException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.core.ReportParameters;
import org.wso2.carbon.reporting.core.internal.ReportingComponent;
import org.wso2.carbon.reporting.core.utils.CommonUtil;
import org.wso2.carbon.reporting.util.OMElementHandler;

public class ReportingResourcesSupplier
extends AbstractAdmin {
    private static final String REPORTS_PATH = "/repository/reports/";
    private static Log log = LogFactory.getLog(ReportingResourcesSupplier.class);

    public String getReportResources(String componentName, String reportTemplate) throws ReportingException {
        try {
            UserRegistry registry;
            try {
                registry = ReportingComponent.getRegistryService().getConfigSystemRegistry();
            }
            catch (RegistryException e) {
                throw new ReportingException("Failed to get registry", (Throwable)e);
            }
            String template = CommonUtil.getReportResources(componentName, reportTemplate, (Registry)registry);
            return template;
        }
        catch (XMLStreamException e) {
            throw new ReportingException(" Failed to get report template", (Throwable)e);
        }
    }

    public String getJRXMLFileContent(String componentName, String reportTemplate) throws ReportingException {
        UserRegistry registry;
        try {
            registry = ReportingComponent.getRegistryService().getConfigSystemRegistry();
        }
        catch (RegistryException e) {
            throw new ReportingException("Failed to get registry", (Throwable)e);
        }
        String template = CommonUtil.getJRXMLFileContent(componentName, reportTemplate, (Registry)registry);
        return template;
    }

    public List<String> getAllReports() throws ReportingException {
        return CommonUtil.getAllReports(this.getConfigUserRegistry());
    }

    public void deleteReportTemplate(String templateName) throws ReportingException {
        CommonUtil.deleteReportTemplate(templateName, this.getConfigSystemRegistry());
    }

    public boolean updateReport(String fileName, String fileContent) throws ReportingException, JRException {
        return CommonUtil.updateReport(fileName, fileContent, this.getConfigSystemRegistry());
    }

    public ReportParameters[] getReportParam(String reportName) throws ReportingException, XMLStreamException {
        String reportContent = this.getReportResources(null, reportName);
        ArrayList<ReportParameters> parameterList = new ArrayList<ReportParameters>();
        if (reportContent != null) {
            Iterator iterator;
            OMElement reportTemplateOmElement = OMElementHandler.createOMElement((String)reportContent);
            if (reportTemplateOmElement != null && (iterator = reportTemplateOmElement.getChildrenWithName(new QName("parameter"))) != null) {
                while (iterator.hasNext()) {
                    ReportParameters parameter = new ReportParameters();
                    OMElement omElement = (OMElement)iterator.next();
                    String paramName = omElement.getAttribute(new QName("name")).getAttributeValue();
                    parameter.setParamName(paramName);
                    String paramValue = omElement.getAttribute(new QName("class")).getAttributeValue();
                    parameter.setParamValue(paramValue);
                    parameterList.add(parameter);
                }
            }
        } else {
            log.error((Object)("Did not find a report called " + reportName));
            return null;
        }
        ReportParameters[] parametersArray = parameterList.toArray(new ReportParameters[parameterList.size()]);
        return parametersArray;
    }
}

