/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.services;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.activation.DataHandler;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.core.utils.ImageLoader;

public class JrxmlFileUploader
extends AbstractAdmin {
    String status = "failed";

    public String uploadJrxmlFile(String fileName, String fileContent) throws ReportingException, JRException {
        if (!"".equals(fileContent)) {
            try {
                try {
                    byte[] templateContent = fileContent.getBytes();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(templateContent);
                    JRXmlLoader.load((InputStream)inputStream);
                }
                catch (JRException e) {
                    throw new JRException(fileName + " is not a valide template", (Throwable)e);
                }
                Registry registry = this.getConfigSystemRegistry();
                Resource reportFilesResource = registry.newResource();
                reportFilesResource.setContent((Object)fileContent);
                registry.put("/repository/reports/org.wso2.carbon.reporting/" + fileName + ".jrxml", reportFilesResource);
                this.status = "success";
            }
            catch (RegistryException e) {
                throw new ReportingException("Failed to upload \"" + fileName + "\"", (Throwable)e);
            }
        }
        throw new ReportingException("File content empty or in-complete template");
        return this.status;
    }

    public String uploadLogo(String imageName, String reportName, DataHandler imageContent) throws ReportingException {
        if ("".equals(imageContent)) {
            throw new ReportingException("File content empty or in-complete template");
        }
        ImageLoader loader = new ImageLoader();
        loader.saveImage(imageName, reportName, imageContent);
        return this.status;
    }
}

