/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.jaxen.JaxenException;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.core.ReportBean;
import org.wso2.carbon.reporting.core.ReportingService;
import org.wso2.carbon.reporting.core.datasource.ReportDataSourceManager;
import org.wso2.carbon.reporting.core.internal.ReportingComponent;
import org.wso2.carbon.reporting.core.services.ReportingResourcesSupplier;
import org.wso2.carbon.reporting.core.utils.ImageLoader;
import org.wso2.carbon.reporting.util.JasperPrintProvider;
import org.wso2.carbon.reporting.util.ReportDataSource;
import org.wso2.carbon.reporting.util.ReportParamMap;
import org.wso2.carbon.reporting.util.ReportStream;

public class DBReportingService
implements ReportingService {
    private static Log log = LogFactory.getLog(DBReportingService.class);
    private Connection connection;

    @Override
    public byte[] getReport(ReportBean reportBean, ReportParamMap[] reportParamMap) throws ReportingException, JRException {
        byte[] reportBytes = new byte[]{};
        ByteArrayOutputStream byteArrayOutputStream = null;
        String templateName = reportBean.getTemplateName();
        String dataSourceName = reportBean.getDataSourceName();
        String reportType = reportBean.getReportType();
        if (templateName == null || dataSourceName == null || reportType == null) {
            throw new ReportingException("templateName ,dataSourceName or reportType null ");
        }
        try {
            JasperPrint jasperPrint;
            String template;
            try {
                template = new ReportingResourcesSupplier().getReportResources(null, templateName);
            }
            catch (ReportingException e) {
                log.error((Object)"Failed to report template", (Throwable)e);
                throw new ReportingException("Failed get template " + templateName, (Throwable)e);
            }
            if (template == null) {
                throw new ReportingException("empty report template found :" + templateName);
            }
            this.connection = new ReportDataSourceManager().getJDBCConnection(dataSourceName);
            if (this.connection != null) {
                try {
                    jasperPrint = new JasperPrintProvider().createJasperPrint((Object)this.connection, template, reportParamMap);
                }
                catch (JRException e) {
                    throw new JRException("Can't create JasperPrint Object from " + templateName, (Throwable)e);
                }
            } else {
                log.error((Object)"valid connection not found to generate report");
                throw new ReportingException("db connection null");
            }
            byteArrayOutputStream = new ReportStream().getReportStream(jasperPrint, reportType);
            if (byteArrayOutputStream != null) {
                reportBytes = byteArrayOutputStream.toByteArray();
            }
        }
        catch (Exception e) {
            throw new ReportingException("Failed to generate report", (Throwable)e);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    String msg = "Failed to close the db connection";
                    log.error((Object)msg, (Throwable)e);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the report stream");
                }
            }
        }
        return reportBytes;
    }

    public byte[] getJRDataSourceReport(ReportDataSource dataSource, String templateName, ReportParamMap[] parameterMap, String reportType) throws ReportingException, JRException {
        byte[] reportBytes = new byte[]{};
        ByteArrayOutputStream byteArrayOutputStream = null;
        ImageLoader imageLoader = null;
        if (templateName == null || reportType == null) {
            throw new ReportingException("templateName ,dataSourceName or reportType null ");
        }
        try {
            JasperPrint jasperPrint;
            String template;
            try {
                template = new ReportingResourcesSupplier().getReportResources(null, templateName);
            }
            catch (ReportingException e) {
                log.error((Object)"Failed to report template", (Throwable)e);
                throw new ReportingException("Failed get template " + templateName, (Throwable)e);
            }
            if (template == null) {
                throw new ReportingException("empty report template found :" + templateName);
            }
            String[] subReports = this.getSubreportNames(template);
            String[] subReportTemplates = null;
            if (subReports != null) {
                subReportTemplates = new String[subReports.length];
                int i = 0;
                for (String aSubRep : subReports) {
                    subReportTemplates[i] = new ReportingResourcesSupplier().getReportResources(null, aSubRep);
                    imageLoader = new ImageLoader();
                    imageLoader.loadTempImages(aSubRep, subReportTemplates[i]);
                    ++i;
                }
            }
            imageLoader = new ImageLoader();
            imageLoader.loadTempImages(templateName, template);
            try {
                jasperPrint = new JasperPrintProvider().createJasperPrint(dataSource, template, parameterMap, subReports, subReportTemplates);
            }
            catch (JRException e) {
                throw new JRException("Can't create JasperPrint Object from " + templateName, (Throwable)e);
            }
            byteArrayOutputStream = new ReportStream().getReportStream(jasperPrint, reportType);
            if (byteArrayOutputStream != null) {
                reportBytes = byteArrayOutputStream.toByteArray();
            }
            imageLoader.deleteTempImages();
        }
        catch (Exception ex) {
            throw new ReportingException("Failed to generate report", (Throwable)ex);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the report stream");
                }
            }
            if (imageLoader != null) {
                imageLoader.deleteTempImages();
            }
        }
        return reportBytes;
    }

    private String[] getSubreportNames(String template) throws XMLStreamException, JaxenException {
        ByteArrayInputStream is = new ByteArrayInputStream(template.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(is);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMDocument document = builder.getDocument();
        OMElement documentElement = document.getOMDocumentElement();
        AXIOMXPath xpathExpression = new AXIOMXPath("//a:subreport");
        xpathExpression.addNamespace("a", "http://jasperreports.sourceforge.net/jasperreports");
        List nodeList = xpathExpression.selectNodes((Object)documentElement);
        ArrayList<String> repNames = new ArrayList<String>();
        if (nodeList == null | nodeList.size() < 1) {
            return null;
        }
        for (Object obj : nodeList) {
            if (!(obj instanceof OMElement)) continue;
            OMElement subReport = (OMElement)obj;
            Iterator iterator = subReport.getChildrenWithLocalName("subreportExpression");
            OMElement element = (OMElement)iterator.next();
            String reportName = element.getText();
            reportName = reportName.replaceAll("\\{", "");
            reportName = reportName.replaceAll("\\}", "");
            reportName = reportName.replaceAll("\\$P", "");
            reportName = reportName.replaceAll("\\$F", "");
            repNames.add(reportName);
        }
        String[] names = new String[repNames.size()];
        names = repNames.toArray(names);
        return names;
    }

    public List<String> getCarbonDataSourceNames() {
        DataSourceInformationRepositoryService dataSourceService = ReportingComponent.getCarbonDataSourceService();
        if (dataSourceService == null) {
            log.error((Object)"Carbon data source service is not available, returning empty list");
            return new ArrayList<String>();
        }
        ArrayList<String> namesList = new ArrayList<String>();
        Iterator dataItr = dataSourceService.getDataSourceInformationRepository().getAllDataSourceInformation();
        while (dataItr.hasNext()) {
            DataSourceInformation dataInfo = (DataSourceInformation)dataItr.next();
            namesList.add(dataInfo.getDatasourceName());
        }
        return namesList;
    }
}

