/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.reporting.core.internal.JRxmlFileBundleListener;

public class ReportingComponent {
    private static Log log = LogFactory.getLog(ReportingComponent.class);
    private static RegistryService registryServiceInstance;
    private static DataSourceInformationRepositoryService dataSourceService1;

    protected void activate(ComponentContext componentContext) {
        try {
            Bundle[] bundles;
            JRxmlFileBundleListener JRxmlFileBundleListener2 = new JRxmlFileBundleListener();
            componentContext.getBundleContext().addBundleListener((BundleListener)JRxmlFileBundleListener2);
            for (Bundle bundle : bundles = componentContext.getBundleContext().getBundles()) {
                if (bundle.getState() != 32) continue;
                JRxmlFileBundleListener2.addJrXmlToRegistry(bundle);
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        log.debug((Object)"report definition  deactivated");
    }

    protected void setRegistryService(RegistryService registryService) {
        registryServiceInstance = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryServiceInstance = null;
    }

    public static RegistryService getRegistryService() throws RegistryException {
        if (registryServiceInstance == null) {
            throw new RegistryException("Registry Service instance null");
        }
        return registryServiceInstance;
    }

    protected void setCarbonDataSourceService(DataSourceInformationRepositoryService dataSourceService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Carbon Data Sources Service");
        }
        dataSourceService1 = dataSourceService;
    }

    protected void unsetCarbonDataSourceService(DataSourceInformationRepositoryService dataSourceService) {
        dataSourceService1 = dataSourceService;
    }

    public static DataSourceInformationRepositoryService getCarbonDataSourceService() {
        return dataSourceService1;
    }
}

