/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.core.internal.ReportingComponent;

public class JRxmlFileBundleListener
implements BundleListener {
    private static Log log = LogFactory.getLog(JRxmlFileBundleListener.class);

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        try {
            if (bundleEvent.getType() == 2) {
                this.addJrXmlToRegistry(bundle);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred when putting jrXml file to registry in bundle " + bundle.getSymbolicName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJrXmlToRegistry(Bundle bundle) throws ReportingException {
        BundleContext bundleContext = bundle.getBundleContext();
        String reportResource = "/reports/";
        Enumeration enumeration = bundleContext.getBundle().getEntryPaths(reportResource);
        if (enumeration == null) {
            return;
        }
        try {
            RegistryService registryService = ReportingComponent.getRegistryService();
            UserRegistry registry = registryService.getConfigSystemRegistry();
            registry.beginTransaction();
            Resource reportFilesResource = registry.newResource();
            InputStream xmlStream = null;
            try {
                while (enumeration.hasMoreElements()) {
                    String path = enumeration.nextElement().toString();
                    URL url = bundleContext.getBundle().getResource(path);
                    if (url == null) {
                        return;
                    }
                    xmlStream = url.openStream();
                    if (xmlStream == null) {
                        return;
                    }
                    reportFilesResource.setContentStream(xmlStream);
                    String location = "/repository/reports/org.wso2.carbon.reporting/" + bundle.getSymbolicName() + "/" + path.split("/")[1];
                    if (registry.resourceExists(location)) continue;
                    registry.put(location, reportFilesResource);
                }
            }
            finally {
                xmlStream.close();
            }
            registry.commitTransaction();
        }
        catch (Exception e) {
            String msg = "Error occurred adding .jrxml file from " + bundle.getSymbolicName() + " to registry";
            throw new ReportingException(msg, (Throwable)e);
        }
    }
}

