/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformationRepository;
import org.apache.synapse.commons.datasource.DataSourceRepositoryHolder;
import org.apache.synapse.commons.datasource.DataSourceRepositoryManager;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.core.internal.ReportingComponent;

public class ReportDataSourceManager {
    private static Log log = LogFactory.getLog(ReportDataSourceManager.class);

    public Connection getJDBCConnection(String dataSourceName) throws ReportingException {
        Connection connection = null;
        DataSourceInformationRepositoryService repositoryService = ReportingComponent.getCarbonDataSourceService();
        if (repositoryService != null) {
            DataSource dataSource;
            DataSourceInformationRepository datasourceRepo = repositoryService.getDataSourceInformationRepository();
            DataSourceRepositoryHolder dataSourceHelper = DataSourceRepositoryHolder.getInstance();
            dataSourceHelper.init(datasourceRepo, null);
            DataSourceRepositoryManager repositoryManager = dataSourceHelper.getDataSourceRepositoryManager();
            if (repositoryManager != null && (dataSource = repositoryManager.getDataSource(dataSourceName)) != null) {
                try {
                    connection = dataSource.getConnection();
                }
                catch (SQLException e) {
                    throw new ReportingException("Failed to get data source connection for \"" + dataSourceName + "\"", (Throwable)e);
                }
            }
        }
        return connection;
    }
}

