/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import org.wso2.carbon.reporting.api.ReportingException;
import org.wso2.carbon.reporting.util.types.ExcelReport;
import org.wso2.carbon.reporting.util.types.HtmlReport;
import org.wso2.carbon.reporting.util.types.PdfReport;

public class ReportGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getReportStream(JasperPrint jasperPrint, String reportType) throws ReportingException, JRException {
        ByteArrayOutputStream outputStream;
        block11: {
            outputStream = null;
            try {
                try {
                    if (reportType.equals("pdf")) {
                        PdfReport pdfReport = new PdfReport();
                        outputStream = pdfReport.generatePdfReport(jasperPrint);
                        break block11;
                    }
                    if (reportType.equals("excel")) {
                        ExcelReport excelReport = new ExcelReport();
                        outputStream = excelReport.generateExcelReport(jasperPrint);
                        break block11;
                    }
                    if (reportType.equals("html")) {
                        HtmlReport htmlReport = new HtmlReport();
                        outputStream = htmlReport.generateHtmlReport(jasperPrint);
                        break block11;
                    }
                    throw new ReportingException("requested report type " + reportType + " invalid");
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ReportingException(" Error occurred when closing report stream", (Throwable)e);
            }
            catch (JRException e) {
                throw new JRException("Failed to generate " + reportType + " report", (Throwable)e);
            }
        }
        if (outputStream == null) {
            throw new ReportingException("generated report byte stream null");
        }
        return outputStream.toByteArray();
    }
}

