/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.reporting.util.types;

import java.io.ByteArrayOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import org.wso2.carbon.reporting.api.ReportingException;

public class ExcelReport {
    public ByteArrayOutputStream generateExcelReport(JasperPrint jasperPrint) throws ReportingException, JRException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (jasperPrint == null) {
            throw new ReportingException("jasperPrint null, can't convert to excel report");
        }
        try {
            jasperPrint.setProperty("net.sf.jasperreports.export.xls.exclude.origin.keep.first.band.1", "pageHeader");
            jasperPrint.setProperty("net.sf.jasperreports.export.xls.exclude.origin.keep.first.band.2", "columnHeader");
            jasperPrint.setProperty("net.sf.jasperreports.export.xls.exclude.origin.band.2", "pageFooter");
            JExcelApiExporter jExcelApiExporter = new JExcelApiExporter();
            jExcelApiExporter.setParameter(JExcelApiExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jExcelApiExporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            jExcelApiExporter.setParameter(JExcelApiExporterParameter.OUTPUT_STREAM, (Object)outputStream);
            jExcelApiExporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_IGNORE_CELL_BORDER, (Object)Boolean.TRUE);
            jExcelApiExporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            jExcelApiExporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            jExcelApiExporter.setParameter(JExcelApiExporterParameter.OFFSET_X, (Object)0);
            jExcelApiExporter.setParameter(JExcelApiExporterParameter.OFFSET_Y, (Object)0);
            jExcelApiExporter.exportReport();
        }
        catch (JRException e) {
            throw new JRException("Error occurred exporting Excel report ", (Throwable)e);
        }
        return outputStream;
    }
}

