/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.legacy;

import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.JRProperties;

public abstract class BorderOffset {
    public static final String PROPERTY_LEGACY_BORDER_OFFSET = "net.sf.jasperreports.export.legacy.border.offset";
    public static final BorderOffset DEFAULT = new BorderOffset(){

        public float getValue(JRPen pen) {
            return 0.0f;
        }
    };
    public static final BorderOffset LEGACY = new BorderOffset(){

        public float getValue(JRPen pen) {
            float lineWidth = pen.getLineWidth().floatValue();
            LineStyleEnum lineStyle = pen.getLineStyleValue();
            if (lineWidth == 0.5f && lineStyle == LineStyleEnum.SOLID) {
                return 0.25f;
            }
            if (lineWidth == 1.0f && (lineStyle == LineStyleEnum.SOLID || lineStyle == LineStyleEnum.DASHED)) {
                return 0.5f;
            }
            return 0.0f;
        }
    };
    private static final ThreadLocal<BorderOffset> threadInstance = new ThreadLocal();

    public static void setLegacy(boolean isLegacy) {
        threadInstance.set(isLegacy ? LEGACY : DEFAULT);
    }

    public static float getOffset(JRPen pen) {
        BorderOffset borderOffset = threadInstance.get();
        if (borderOffset == null) {
            borderOffset = JRProperties.getBooleanProperty(PROPERTY_LEGACY_BORDER_OFFSET) ? LEGACY : DEFAULT;
        }
        return borderOffset.getValue(pen);
    }

    public abstract float getValue(JRPen var1);
}

