/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.components.charts.ChartSettings;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.components.spiderchart.SpiderPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class SpiderChartCompiler
implements ComponentCompiler {
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        SpiderChartComponent chart = (SpiderChartComponent)component;
        SpiderChartCompiler.collectExpressions(chart.getChartSettings(), collector);
        SpiderChartCompiler.collectExpressions((SpiderDataset)chart.getDataset(), collector);
        SpiderChartCompiler.collectExpressions((SpiderPlot)chart.getPlot(), collector);
    }

    public static void collectExpressions(SpiderDataset dataset, JRExpressionCollector collector) {
        if (dataset != null) {
            collector.collect(dataset);
            JRCategorySeries[] categorySeries = dataset.getSeries();
            if (categorySeries != null && categorySeries.length > 0) {
                JRExpressionCollector seriesCollector = collector.getCollector(dataset);
                for (int j = 0; j < categorySeries.length; ++j) {
                    seriesCollector.addExpression(categorySeries[j].getSeriesExpression());
                    seriesCollector.addExpression(categorySeries[j].getCategoryExpression());
                    seriesCollector.addExpression(categorySeries[j].getValueExpression());
                    seriesCollector.addExpression(categorySeries[j].getLabelExpression());
                    seriesCollector.collectHyperlink(categorySeries[j].getItemHyperlink());
                }
            }
        }
    }

    public static void collectExpressions(SpiderPlot spiderPlot, JRExpressionCollector collector) {
        if (spiderPlot != null) {
            collector.addExpression(spiderPlot.getMaxValueExpression());
        }
    }

    public static void collectExpressions(ChartSettings chart, JRExpressionCollector collector) {
        if (chart != null) {
            collector.addExpression(chart.getTitleExpression());
            collector.addExpression(chart.getSubtitleExpression());
            collector.addExpression(chart.getAnchorNameExpression());
            collector.addExpression(chart.getHyperlinkReferenceExpression());
            collector.addExpression(chart.getHyperlinkAnchorExpression());
            collector.addExpression(chart.getHyperlinkPageExpression());
            collector.addExpression(chart.getHyperlinkTooltipExpression());
            JRHyperlinkParameter[] hyperlinkParameters = chart.getHyperlinkParameters();
            if (hyperlinkParameters != null) {
                for (int i = 0; i < hyperlinkParameters.length; ++i) {
                    JRHyperlinkParameter parameter = hyperlinkParameters[i];
                    if (parameter == null) continue;
                    collector.addExpression(parameter.getValueExpression());
                }
            }
        }
    }

    public void verify(Component component, JRVerifier verifier) {
        SpiderDataset dataset;
        SpiderChartComponent chartComponent = (SpiderChartComponent)component;
        this.verifyEvaluation(verifier, chartComponent);
        ChartSettings chartSettings = chartComponent.getChartSettings();
        if (chartSettings == null) {
            verifier.addBrokenRule("No chart settings for spider chart", (Object)chartComponent);
        }
        if ((dataset = (SpiderDataset)chartComponent.getDataset()) == null) {
            verifier.addBrokenRule("No dataset for spider chart", (Object)chartComponent);
        } else {
            this.verify(verifier, dataset);
        }
        SpiderPlot spiderPlot = (SpiderPlot)chartComponent.getPlot();
        if (dataset == null) {
            verifier.addBrokenRule("No plot set for spider chart", (Object)chartComponent);
        } else {
            this.verify(verifier, spiderPlot);
        }
    }

    protected void verifyEvaluation(JRVerifier verifier, SpiderChartComponent chart) {
        EvaluationTimeEnum evaluationTime = chart.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Spider chart evaluation time cannot be Auto", (Object)chart);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String groupName = chart.getEvaluationGroup();
            if (groupName == null) {
                verifier.addBrokenRule("Evaluation group not set for spider chart", (Object)chart);
            } else {
                JasperDesign report = verifier.getReportDesign();
                if (!report.getGroupsMap().containsKey(groupName)) {
                    verifier.addBrokenRule("Spider chart evaluation group " + groupName + " not found in report", (Object)chart);
                }
            }
        }
    }

    protected void verify(JRVerifier verifier, SpiderDataset dataset) {
        verifier.verifyElementDataset(dataset);
        JRCategorySeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                verifier.verifyHyperlink(series[i].getItemHyperlink());
            }
        }
    }

    protected void verify(JRVerifier verifier, SpiderPlot spiderPlot) {
    }

    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        SpiderChartComponent chart = (SpiderChartComponent)component;
        SpiderChartComponent compiledChart = new SpiderChartComponent(chart, baseFactory);
        return compiledChart;
    }
}

