/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.repomanager.axis2;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.repomanager.axis2.Axis2ArtifactUploadData;
import org.wso2.carbon.repomanager.axis2.DirectoryStructureMetaData;
import org.wso2.carbon.server.admin.service.ServerAdmin;
import org.wso2.carbon.utils.CarbonUtils;

public class Axis2RepoManager
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(Axis2RepoManager.class);
    private static final String RELOAD_REQUIRED = "reload.required";
    private static final String DIRECTORIES_LABEL = "dirs";
    private static final String FILES_LIST_LABEL = "filelist";
    private static final String DIRECTORY_NAME_LABEL = "dirname";
    private static final String FILE_NAME_LABEL = "filename";
    private static final String LIB_DIR = "lib";

    public DirectoryStructureMetaData getDirectoryStructure() throws JSONException {
        String repo = this.getAxisConfig().getRepository().getPath();
        File folder = new File(repo);
        JSONObject obj = new JSONObject();
        this.traverseParent(obj, folder, folder.getName());
        obj.put(DIRECTORY_NAME_LABEL, (Object)folder.getName());
        Boolean reloadRequiredProp = (Boolean)this.getConfigContext().getProperty(RELOAD_REQUIRED);
        boolean reloadRequired = reloadRequiredProp != null ? reloadRequiredProp : false;
        return new DirectoryStructureMetaData(obj.toString(), reloadRequired);
    }

    private void traverseParent(JSONObject obj, File folder, String parent) throws JSONException {
        File[] folderItems;
        JSONArray dirs = new JSONArray();
        JSONArray files = new JSONArray();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().equals(Axis2RepoManager.LIB_DIR);
            }
        };
        if (folder.listFiles(fileFilter).length == 0) {
            JSONObject tempLib = new JSONObject();
            tempLib.put(DIRECTORIES_LABEL, (Object)new JSONArray());
            tempLib.put(FILES_LIST_LABEL, (Object)new JSONArray());
            tempLib.put(DIRECTORY_NAME_LABEL, (Object)LIB_DIR);
            dirs.put((Object)tempLib);
        } else {
            File[] contents;
            JSONObject tempLibDir = new JSONObject();
            JSONArray libFilesArr = new JSONArray();
            for (File file : contents = folder.listFiles(fileFilter)[0].listFiles()) {
                libFilesArr.put((Object)new JSONObject().put(FILE_NAME_LABEL, (Object)file.getName()));
            }
            tempLibDir.put(DIRECTORIES_LABEL, (Object)new JSONArray());
            tempLibDir.put(FILES_LIST_LABEL, (Object)libFilesArr);
            tempLibDir.put(DIRECTORY_NAME_LABEL, (Object)LIB_DIR);
            dirs.put((Object)tempLibDir);
        }
        for (File file : folderItems = folder.listFiles()) {
            if (file.isDirectory() && !file.getName().equalsIgnoreCase(LIB_DIR)) {
                dirs.put((Object)new JSONObject().put(DIRECTORY_NAME_LABEL, (Object)file.getName()));
                this.traverseServiceDir(dirs.getJSONObject(dirs.length() - 1), file);
                continue;
            }
            if (!file.isFile()) continue;
            files.put((Object)new JSONObject().put(FILE_NAME_LABEL, (Object)file.getName()));
        }
        obj.put(DIRECTORIES_LABEL, (Object)dirs);
        obj.put(FILES_LIST_LABEL, (Object)files);
    }

    private void traverseServiceDir(JSONObject obj, File folder) throws JSONException {
        JSONArray dirs = new JSONArray();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().equals(Axis2RepoManager.LIB_DIR);
            }
        };
        if (folder.listFiles(fileFilter).length == 0) {
            JSONObject tempLib = new JSONObject();
            tempLib.put(DIRECTORIES_LABEL, (Object)new JSONArray());
            tempLib.put(FILES_LIST_LABEL, (Object)new JSONArray());
            tempLib.put(DIRECTORY_NAME_LABEL, (Object)LIB_DIR);
            dirs.put((Object)tempLib);
        } else {
            File[] contents;
            JSONObject tempLibDir = new JSONObject();
            JSONArray libFilesArr = new JSONArray();
            for (File file : contents = folder.listFiles(fileFilter)[0].listFiles()) {
                libFilesArr.put((Object)new JSONObject().put(FILE_NAME_LABEL, (Object)file.getName()));
            }
            tempLibDir.put(DIRECTORIES_LABEL, (Object)new JSONArray());
            tempLibDir.put(FILES_LIST_LABEL, (Object)libFilesArr);
            tempLibDir.put(DIRECTORY_NAME_LABEL, (Object)LIB_DIR);
            dirs.put((Object)tempLibDir);
        }
        obj.put(DIRECTORIES_LABEL, (Object)dirs);
        obj.put(FILES_LIST_LABEL, (Object)new JSONArray());
    }

    public boolean uploadArtifact(Axis2ArtifactUploadData[] artifactUploadDataList, String fileUploadDir) throws IOException {
        final String dir = fileUploadDir;
        String fileName = null;
        try {
            File destDir;
            File repoFile = new File(this.getAxisConfig().getRepository().getPath());
            if (CarbonUtils.isURL((String)repoFile.getAbsolutePath())) {
                throw new AxisFault("Uploading services to URL repo is not supported.");
            }
            if (repoFile.getName().equals(fileUploadDir)) {
                destDir = new File(repoFile.getAbsolutePath() + File.separator + LIB_DIR);
            } else {
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().equals(dir);
                    }
                };
                File[] temp = repoFile.listFiles(filter);
                if (temp.length == 0) {
                    throw new AxisFault("The directory you selected is not valid.");
                }
                destDir = new File(temp[0].getAbsolutePath() + File.separator + LIB_DIR);
            }
            if (!destDir.exists() && !destDir.mkdirs()) {
                log.error((Object)("Could not create lib JAR upload directory " + destDir.getAbsolutePath()));
                throw new AxisFault("Could not upload artifacts to " + fileUploadDir);
            }
            for (Axis2ArtifactUploadData uploadData : artifactUploadDataList) {
                fileName = uploadData.getFileName();
                this.writeToFileSystem(destDir.getAbsolutePath(), fileName, uploadData.getDataHandler());
            }
            this.getConfigContext().setProperty(RELOAD_REQUIRED, (Object)Boolean.TRUE);
        }
        catch (IOException e) {
            String msg = "Error occurred while uploading the service " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        return true;
    }

    public boolean deleteLib(String libPath) throws AxisFault {
        File libPathFile = new File(this.getAxisConfig().getRepository().getPath() + libPath);
        if (!libPathFile.exists()) {
            log.error((Object)("The file " + libPathFile.getAbsolutePath() + " does not exist"));
            throw new AxisFault("The file " + libPathFile.getName() + " does not exist");
        }
        if (!libPathFile.canWrite()) {
            log.error((Object)("The file " + libPathFile.getAbsolutePath() + " is write protected"));
            throw new AxisFault("The file " + libPathFile.getName() + " is write protected");
        }
        boolean deletionStatus = libPathFile.delete();
        this.getConfigContext().setProperty(RELOAD_REQUIRED, (Object)Boolean.TRUE);
        return deletionStatus;
    }

    public boolean restartAxis2Server() throws AxisFault {
        if (CarbonContext.getCurrentContext().getTenantId() == -1234) {
            try {
                new ServerAdmin().restart();
            }
            catch (Exception e) {
                String msg = "Could not reload super tenant Axis2 repo. Restart failed.";
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        } else {
            this.reloadTenantAxis2Repo();
        }
        return true;
    }

    private void reloadTenantAxis2Repo() {
        final ConfigurationContext tenantConfigContext = this.getConfigContext();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TenantAxisUtils.terminateTenantConfigContext((ConfigurationContext)tenantConfigContext);
            }
        };
        tenantConfigContext.setProperty(RELOAD_REQUIRED, (Object)Boolean.FALSE);
        Thread reloadThread = new Thread(runnable);
        try {
            reloadThread.join();
        }
        catch (InterruptedException e) {
            log.warn((Object)"Axis2 repo reload thread was interrupted", (Throwable)e);
        }
        reloadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFileSystem(String path, String fileName, DataHandler dataHandler) throws IOException {
        File destFile = new File(path, fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to close FileOutputStream for file " + fileName), (Throwable)e);
                }
            }
        }
    }

    public DataHandler downloadArtifact(String filePath) {
        String resourcePath = this.getAxisConfig().getRepository().getPath() + filePath;
        FileDataSource datasource = new FileDataSource(new File(resourcePath));
        DataHandler handler = new DataHandler((DataSource)datasource);
        return handler;
    }
}

