/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.repomanager.axis2.ui.fileupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.repomanager.axis2.stub.types.Axis2ArtifactUploadData;
import org.wso2.carbon.repomanager.axis2.ui.Axis2RepoManagerClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class Axis2RepoArtifactUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".jar"};
    private static final Log log = LogFactory.getLog(Axis2RepoArtifactUploadExecutor.class);

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified.";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/repomanager-axis2/upload.jsp"));
            return false;
        }
        List fileItemDataArray = (List)fileItemsMap.get("libFileName");
        Map formFieldsMap = this.getFormFieldsMap();
        if (formFieldsMap == null || formFieldsMap.isEmpty()) {
            String msg = "File uploading failed. No Directory specified to upload files.";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/repomanager-axis2/upload.jsp"));
            return false;
        }
        String fileUploadDirName = (String)((ArrayList)formFieldsMap.get("dirName")).get(0);
        Axis2RepoManagerClient repoManagerClient = new Axis2RepoManagerClient(this.configurationContext, serverURL, cookie);
        ArrayList<Axis2ArtifactUploadData> uploadDataList = new ArrayList<Axis2ArtifactUploadData>();
        try {
            for (FileItemData fileItemData : fileItemDataArray) {
                String filename = this.getFileName(fileItemData.getFileItem().getName());
                this.checkServiceFileExtensionValidity(filename, ALLOWED_FILE_EXTENSIONS);
                if (!filename.endsWith(".jar")) {
                    throw new CarbonException("File with extension " + filename + " is not supported!");
                }
                Axis2ArtifactUploadData uploadData = new Axis2ArtifactUploadData();
                uploadData.setFileName(filename);
                uploadData.setDataHandler(fileItemData.getDataHandler());
                uploadDataList.add(uploadData);
            }
            repoManagerClient.uploadArtifacts(uploadDataList.toArray(new Axis2ArtifactUploadData[uploadDataList.size()]), fileUploadDirName);
            request.getSession().setAttribute("uploadStatus", (Object)"successful");
            response.sendRedirect("../" + webContext + "/repomanager-axis2/index.jsp");
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/repomanager-axis2/index.jsp"));
            return false;
        }
    }
}

