/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.repomanager.axis2.ui;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.repomanager.axis2.stub.Axis2RepoManagerJSONExceptionException;
import org.wso2.carbon.repomanager.axis2.stub.Axis2RepoManagerStub;
import org.wso2.carbon.repomanager.axis2.stub.types.Axis2ArtifactUploadData;
import org.wso2.carbon.repomanager.axis2.stub.types.DirectoryStructureMetaData;
import org.wso2.carbon.ui.CarbonUIUtil;

public class Axis2RepoManagerClient {
    private Axis2RepoManagerStub axis2repoManagerStub;

    public Axis2RepoManagerClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        String RepoManagerServiceEPR = serverURL + "Axis2RepoManager";
        this.axis2repoManagerStub = new Axis2RepoManagerStub(ctx, RepoManagerServiceEPR);
        ServiceClient client = this.axis2repoManagerStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setProperty("enableMTOM", (Object)"true");
        options.setTimeOutInMilliSeconds(10000L);
    }

    public Axis2RepoManagerClient(String cookie, ServletConfig config, HttpSession session) throws AxisFault {
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext ctx = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String repoManagerServiceEPR = serverURL + "Axis2RepoManager";
        this.axis2repoManagerStub = new Axis2RepoManagerStub(ctx, repoManagerServiceEPR);
        ServiceClient client = this.axis2repoManagerStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setProperty("enableMTOM", (Object)"true");
        options.setTimeOutInMilliSeconds(10000L);
    }

    public void uploadArtifacts(Axis2ArtifactUploadData[] artifactUploadData, String fileUploadDir) throws Exception {
        this.axis2repoManagerStub.uploadArtifact(artifactUploadData, fileUploadDir);
    }

    public DirectoryStructureMetaData getDirs() throws RemoteException, Axis2RepoManagerJSONExceptionException {
        return this.axis2repoManagerStub.getDirectoryStructure();
    }

    public boolean deleteLibs(String libPath) throws RemoteException {
        return this.axis2repoManagerStub.deleteLib(libPath);
    }

    public boolean restartAxis2Server() throws RemoteException {
        return this.axis2repoManagerStub.restartAxis2Server();
    }

    public void downloadArtifact(String filePath, HttpServletResponse response, String filename) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        DataHandler dataHandler = this.axis2repoManagerStub.downloadArtifact(filePath);
        if (dataHandler != null) {
            int nextChar;
            response.setHeader("Content-Disposition", "fileName=" + filename);
            response.setContentType(dataHandler.getContentType());
            InputStream in = dataHandler.getDataSource().getInputStream();
            while ((nextChar = in.read()) != -1) {
                out.write((int)((char)nextChar));
            }
            out.flush();
            out.close();
            in.close();
        } else {
            out.write("The requested dependency archive was not found on the server".getBytes());
        }
    }
}

