/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.ws.api.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.ws.api.utils.CommonUtil;
import org.wso2.carbon.registry.ws.api.utils.WSDeploymentInterceptor;
import org.wso2.carbon.utils.ConfigurationContextService;

public class WSRegistryServiceComponent {
    private static Log log = LogFactory.getLog(WSRegistryServiceComponent.class);
    private RegistryService registryService;
    private ConfigurationContext configContext;

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Registry WS API bundle is activated");
        }
        try {
            AxisConfiguration config = this.configContext.getAxisConfiguration();
            WSDeploymentInterceptor interceptor = new WSDeploymentInterceptor();
            interceptor.init(config);
            config.addObservers((AxisObserver)interceptor);
        }
        catch (Throwable e) {
            log.error((Object)"Error occured while updating Registry WS API service", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity RP bundle is deactivated");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService set in Registry WS API bundle");
        }
        this.configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService unset in Registry WS API bundle");
        }
        this.configContext = null;
    }

    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
        CommonUtil.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
        CommonUtil.setRegistryService(null);
    }
}

