/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.webdav;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.webdav.RegistryResource;
import org.wso2.carbon.registry.webdav.WebDavEnviorment;

public class RegistryWebDavContext {
    private final Registry registry;
    private final String contextPath;
    private Map<String, RegistryResource> resourceMap = new HashMap<String, RegistryResource>();
    private Map<String, Metadata> metadataMap = new HashMap<String, Metadata>();
    private WebDavEnviorment enviorment;
    private DavSession session;

    public RegistryWebDavContext(Registry registry, String contextPath) {
        this.registry = registry;
        this.contextPath = contextPath;
    }

    public RegistryResource getRegistryResource(String path) throws DavException {
        RegistryResource resource = this.resourceMap.get(path);
        if (resource == null) {
            DavResourceLocator locatorVal = this.getEnviorment().getLocatorFactory().createResourceLocator("/registry/resourcewebdav", "", path);
            resource = new RegistryResource(this, locatorVal);
            this.setRegistryResource(path, resource);
        }
        return resource;
    }

    public void saveDavResourceMimeType(RegistryResource resource) {
        if (!resource.isCollection()) {
            Resource r = resource.getUnderLineResource();
            this.metadataMap.put(r.getPath(), new Metadata(r.getMediaType()));
        }
    }

    public void updateDavResourceMimeType(RegistryResource resource) {
        Metadata metadata;
        Resource r = resource.getUnderLineResource();
        if (r.getMediaType() == null && null != (metadata = this.metadataMap.get(r.getPath()))) {
            String mimeType = metadata.getValue();
            long currentSysTime = System.currentTimeMillis();
            if (currentSysTime - metadata.getLastUpdatedTime() < 15000L && null != mimeType) {
                r.setMediaType(mimeType);
            }
            this.metadataMap.remove(r.getPath());
        }
    }

    public void setRegistryResource(String path, RegistryResource resource) {
        this.resourceMap.put(path, resource);
    }

    public void removeRegistryResource(String path) {
        this.resourceMap.remove(path);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setEnviorment(WebDavEnviorment enviorment) {
        this.enviorment = enviorment;
    }

    public WebDavEnviorment getEnviorment() {
        return this.enviorment;
    }

    public DavSession getSession() {
        return this.session;
    }

    public void setSession(DavSession session) {
        this.session = session;
    }

    private static class Metadata {
        private String value;
        private long lastUpdatedTime;

        private Metadata(String value) {
            this.value = value;
            this.lastUpdatedTime = System.currentTimeMillis();
        }

        public String getValue() {
            return this.value;
        }

        public long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }
    }
}

