/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.webdav;

import java.util.HashSet;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.webdav.RegistryWebDavContext;
import org.wso2.carbon.registry.webdav.WebDavEnviorment;
import org.wso2.carbon.registry.webdav.WebdavServiceComponet;

public class RegistrySessionProvider
implements DavSessionProvider {
    private static Logger log = LoggerFactory.getLogger(RegistrySessionProvider.class);
    private CredentialsProvider credentialsProvider;
    private ThreadLocal<RegistryWebDavContext> threadLocal;
    private WebDavEnviorment enviorment;

    public RegistrySessionProvider(CredentialsProvider credentialsProvider, ThreadLocal<RegistryWebDavContext> threadLocal, WebDavEnviorment enviorment) {
        this.credentialsProvider = credentialsProvider;
        this.threadLocal = threadLocal;
        this.enviorment = enviorment;
        this.enviorment.setSessionProvider(this);
    }

    public boolean attachSession(WebdavRequest request) throws DavException {
        try {
            HttpSession session = request.getSession(true);
            RegistryWebDavContext webdavContext = (RegistryWebDavContext)session.getAttribute("WebDavContext");
            if (webdavContext == null) {
                Credentials credentials = this.credentialsProvider.getCredentials((HttpServletRequest)request);
                SimpleCredentials simpleCredentials = (SimpleCredentials)credentials;
                String userID = simpleCredentials.getUserID();
                String password = new String(simpleCredentials.getPassword());
                if (userID == null || password == null || userID.length() == 0 || password.length() == 0) {
                    throw new DavException(401, "Bassic HTTP Autentication is required");
                }
                Registry registry = WebdavServiceComponet.getRegistryInstance(userID, password);
                webdavContext = new RegistryWebDavContext(registry, request.getContextPath());
                webdavContext.setEnviorment(this.enviorment);
                session.setAttribute("WebDavContext", (Object)webdavContext);
            }
            this.threadLocal.set(webdavContext);
            request.setDavSession(new DavSession(){
                private final HashSet lockTokens = new HashSet();

                public void removeReference(Object reference) {
                }

                public void removeLockToken(String token) {
                    this.lockTokens.remove(token);
                }

                public String[] getLockTokens() {
                    return this.lockTokens.toArray(new String[this.lockTokens.size()]);
                }

                public void addReference(Object reference) {
                }

                public void addLockToken(String token) {
                    this.lockTokens.add(token);
                }
            });
            webdavContext.setSession(request.getDavSession());
            return true;
        }
        catch (LoginException e) {
            e.printStackTrace();
            throw new DavException(400, (Throwable)e);
        }
        catch (ServletException e) {
            e.printStackTrace();
            throw new DavException(400, (Throwable)e);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            throw new DavException(400, (Throwable)e);
        }
    }

    public void releaseSession(WebdavRequest request) {
    }
}

