/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.webdav;

import java.io.IOException;
import javax.jcr.Repository;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.server.BasicCredentialsProvider;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.webdav.RegistryResource;
import org.wso2.carbon.registry.webdav.RegistrySessionProvider;
import org.wso2.carbon.registry.webdav.RegistryWebDavContext;
import org.wso2.carbon.registry.webdav.WebDavEnviorment;
import org.wso2.carbon.registry.webdav.WebdavServiceComponet;
import sun.misc.BASE64Decoder;

public class RegistryServlet
extends SimpleWebdavServlet {
    public static final Log log = LogFactory.getLog(SimpleWebdavServlet.class);
    public static final String WEBDAV_CONTEXT = "WebDavContext";
    private static ThreadLocal<RegistryWebDavContext> threadLocalData = new ThreadLocal();
    private WebDavEnviorment enviorment = new WebDavEnviorment();

    public void init() throws ServletException {
        super.init();
        log.debug((Object)"Starting Registry WebDAV Servlet");
        this.setResourceFactory(new DavResourceFactory(){

            public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
                return this.createResource(locator);
            }

            public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
                return this.createResource(locator);
            }

            private RegistryResource createResource(DavResourceLocator locator) throws DavException {
                try {
                    RegistryWebDavContext webDavContext = (RegistryWebDavContext)threadLocalData.get();
                    RegistryResource registryResource = new RegistryResource(webDavContext, locator);
                    webDavContext.setRegistryResource(registryResource.getLocator().getResourcePath(), registryResource);
                    return registryResource;
                }
                catch (DavException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        this.enviorment.setResourceFactory(this.getResourceFactory());
        this.enviorment.setLocatorFactory(this.getLocatorFactory());
        this.setDavSessionProvider(new RegistrySessionProvider((CredentialsProvider)new BasicCredentialsProvider("missing-auth-mapping"), threadLocalData, this.enviorment));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            log.debug((Object)("doGet() Invoked by " + req.getRemoteUser()));
            this.findAndSetWebdavContext2ThreadLocal(req);
            super.doGet(req, resp);
        }
        catch (RegistryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            log.debug((Object)("doPost() Invoked by " + req.getRemoteUser()));
            this.findAndSetWebdavContext2ThreadLocal(req);
            super.doPost(req, resp);
        }
        catch (RegistryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doMkCol(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (resource instanceof RegistryResource) {
            ((RegistryResource)resource).setUnderLineResource((Resource)new CollectionImpl());
        }
        super.doMkCol(request, response, resource);
    }

    private void findAndSetWebdavContext2ThreadLocal(HttpServletRequest req) throws IOException, RegistryException {
        HttpSession session = req.getSession(true);
        RegistryWebDavContext webdavContext = (RegistryWebDavContext)session.getAttribute(WEBDAV_CONTEXT);
        if (webdavContext == null) {
            String[] credentails = this.retriveUserNameAndPassword(req);
            Registry registry = credentails != null ? WebdavServiceComponet.getRegistryInstance(credentails[0], credentails[1]) : WebdavServiceComponet.getRegistryInstance(null, null);
            if (registry == null) {
                throw new RegistryException("No Registry can be found for the registry");
            }
            webdavContext = new RegistryWebDavContext(registry, req.getContextPath());
            session.setAttribute(WEBDAV_CONTEXT, (Object)webdavContext);
        }
        threadLocalData.set(webdavContext);
    }

    private String[] retriveUserNameAndPassword(HttpServletRequest request) throws IOException {
        String auth = request.getHeader("Authorization");
        if (!auth.toUpperCase().startsWith("BASIC ")) {
            return null;
        }
        String userpassEncoded = auth.substring(6);
        BASE64Decoder dec = new BASE64Decoder();
        String userpassDecoded = new String(dec.decodeBuffer(userpassEncoded));
        return userpassDecoded.split(":");
    }

    public Repository getRepository() {
        return null;
    }
}

