/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.webdav.RegistryWebDavContext;

public class RegistryResource
implements DavResource {
    private Resource underLineResource;
    private Registry registry;
    private RegistryWebDavContext resourceCache;
    private DavResourceLocator locator;
    private String path;
    private boolean doesNotExists = false;
    private Map<DavPropertyName, DavProperty> properties = new HashMap<DavPropertyName, DavProperty>();
    private boolean lockable = false;
    private LockManager lockManager;
    private DavSession session;
    private static final String COMPLIANCE_CLASSES = DavCompliance.concatComplianceClasses((String[])new String[]{"1"});

    public RegistryResource(RegistryWebDavContext webdavContext, DavResourceLocator locator) throws DavException {
        this.registry = webdavContext.getRegistry();
        if (this.registry == null) {
            throw new DavException(403, "Registry Not Found");
        }
        this.locator = locator;
        this.resourceCache = webdavContext;
        String path = locator.getResourcePath();
        if (path.startsWith("/registry/resourcewebdav")) {
            path = path.substring("/registry/resourcewebdav".length());
        }
        if (path.trim().length() == 0) {
            path = "/";
        }
        this.path = path.trim();
    }

    private Resource getUnderlineResource() {
        try {
            this.underLineResource = this.registry.get(this.path);
            this.addRequiredProperties();
            return this.underLineResource;
        }
        catch (RegistryException e) {
            this.doesNotExists = true;
            throw new RuntimeException(e);
        }
    }

    private void addRequiredProperties() {
        if (this.underLineResource instanceof Collection) {
            this.addDavProperty(DavPropertyName.RESOURCETYPE, new ResourceType(1));
            this.addDavProperty(DavPropertyName.ISCOLLECTION, "1");
        } else {
            this.addDavProperty(DavPropertyName.RESOURCETYPE, new ResourceType(0));
            this.addDavProperty(DavPropertyName.ISCOLLECTION, "0");
            this.addDavProperty(DavPropertyName.GETCONTENTLENGTH, this.getContentLength());
            this.addDavProperty(DavPropertyName.GETCONTENTTYPE, this.underLineResource.getMediaType());
        }
        this.addDavProperty(DavPropertyName.create((String)"author"), this.underLineResource.getAuthorUserName());
        this.addDavProperty(DavPropertyName.GETETAG, this.getETag());
        this.addDavProperty(DavPropertyName.DISPLAYNAME, this.getDisplayName());
        this.addDavProperty(DavPropertyName.CREATIONDATE, DavConstants.creationDateFormat.format(this.underLineResource.getCreatedTime()));
        this.addDavProperty(DavPropertyName.GETLASTMODIFIED, DavConstants.modificationDateFormat.format(this.underLineResource.getLastModified()));
    }

    private String getETag() {
        return this.path;
    }

    private int getContentLength() {
        int bytesRead = 0;
        try {
            Object o = this.underLineResource.getContent();
            if (null != o && o instanceof byte[]) {
                bytesRead = ((byte[])o).length;
            }
        }
        catch (RegistryException e) {
            bytesRead = 0;
        }
        return bytesRead;
    }

    private void addDavProperty(DavPropertyName dName, Object value) {
        DefaultDavProperty davProp = new DefaultDavProperty(dName, value);
        this.properties.put(davProp.getName(), (DavProperty)davProp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        try {
            if (!(resource instanceof RegistryResource)) throw new DavException(400, "Only support " + RegistryResource.class + " as members");
            if (!(this.getUnderlineResource() instanceof Collection)) throw new DavException(400, "Only add resources to Collections");
            if (!resource.getResourcePath().contains(this.path)) throw new DavException(400, "Internal Error, Parent and target path does not match");
            Resource resourceImpl = ((RegistryResource)resource).getUnderLineResource();
            boolean isCollection = resourceImpl instanceof Collection;
            if (null == resourceImpl) {
                resourceImpl = isCollection ? new CollectionImpl() : new ResourceImpl();
                ((ResourceImpl)resourceImpl).setPath(resource.getResourcePath());
                ((RegistryResource)resource).setUnderLineResource(resourceImpl);
                this.resourceCache.updateDavResourceMimeType((RegistryResource)resource);
                if (null == resourceImpl.getMediaType() && resourceImpl.getPath().indexOf(46) == -1) {
                    resourceImpl.setMediaType("text/plain");
                }
            }
            if (!isCollection) {
                resourceImpl.setContentStream(inputContext.getInputStream());
            }
            this.resourceCache.getRegistry().put(resource.getResourcePath(), resourceImpl);
            return;
        }
        catch (RegistryException e) {
            e.printStackTrace();
            throw new DavException(400, (Throwable)e);
        }
    }

    public boolean exists() {
        if (this.doesNotExists) {
            return false;
        }
        try {
            this.getUnderlineResource();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isCollection() {
        return this.exists() && this.getUnderlineResource() instanceof Collection;
    }

    public DavResource getCollection() {
        try {
            int index = this.path.lastIndexOf("/");
            if (index >= 0) {
                String parentPath = this.path.substring(0, index + 1);
                return this.resourceCache.getRegistryResource(parentPath);
            }
            throw new RuntimeException("Illegal Path " + this.path);
        }
        catch (DavException e) {
            throw new RuntimeException(e);
        }
    }

    public String getComplianceClass() {
        return COMPLIANCE_CLASSES;
    }

    public String getDisplayName() {
        String fullpath = this.path;
        if (fullpath.equals("/")) {
            return "/";
        }
        String[] tokens = fullpath.split("/");
        return tokens[tokens.length - 1] + "_";
    }

    public ActiveLock getLock(Type type, Scope scope) {
        if (this.lockable) {
            ActiveLock lock = null;
            if (this.exists() && Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope)) {
                lock = this.lockManager.getLock(type, scope, (DavResource)this);
            }
            return lock;
        }
        throw new UnsupportedOperationException();
    }

    public ActiveLock[] getLocks() {
        if (this.lockable) {
            ActiveLock[] activeLockArray;
            ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
            if (writeLock != null) {
                ActiveLock[] activeLockArray2 = new ActiveLock[1];
                activeLockArray = activeLockArray2;
                activeLockArray2[0] = writeLock;
            } else {
                activeLockArray = new ActiveLock[]{};
            }
            return activeLockArray;
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasLock(Type type, Scope scope) {
        if (this.lockable) {
            return this.getLock(type, scope) != null;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isLockable(Type type, Scope scope) {
        return this.lockable;
    }

    public void addLockManager(LockManager lockmgr) {
        this.lockManager = lockmgr;
    }

    public void unlock(String lockToken) throws DavException {
        if (this.lockable) {
            ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
            if (lock == null) {
                throw new DavException(412);
            }
            if (!lock.isLockedByToken(lockToken)) {
                throw new DavException(423);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.lockManager.releaseLock(lockToken, (DavResource)this);
    }

    public ActiveLock lock(LockInfo lockInfo) throws DavException {
        if (this.lockable) {
            if (this.isLockable(lockInfo.getType(), lockInfo.getScope())) {
                return this.lockManager.createLock(lockInfo, (DavResource)this);
            }
            throw new DavException(412, "Unsupported lock type or scope.");
        }
        throw new UnsupportedOperationException();
    }

    public ActiveLock refreshLock(LockInfo lockInfo, String lockToken) throws DavException {
        if (this.lockable) {
            if (!this.exists()) {
                throw new DavException(404);
            }
            ActiveLock lock = this.getLock(lockInfo.getType(), lockInfo.getScope());
            if (lock == null) {
                throw new DavException(412, "No lock with the given type/scope present on resource " + this.getResourcePath());
            }
            lock = this.lockManager.refreshLock(lockInfo, lockToken, (DavResource)this);
            return lock;
        }
        throw new UnsupportedOperationException();
    }

    public void removeMember(DavResource member) throws DavException {
        try {
            String path = member.getResourcePath();
            this.resourceCache.saveDavResourceMimeType((RegistryResource)member);
            this.resourceCache.removeRegistryResource(path);
            this.registry.delete(path);
        }
        catch (RegistryException e) {
            throw new DavException(400);
        }
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        this.getUnderlineResource().removeProperty(propertyName.getName());
    }

    public void setProperty(DavProperty property) throws DavException {
        this.getUnderlineResource().setProperty(property.getName().getName(), (String)property.getValue());
    }

    public String getResourcePath() {
        return this.path;
    }

    public void move(DavResource destination) throws DavException {
        try {
            this.registry.move(this.path, destination.getResourcePath());
            this.resourceCache.saveDavResourceMimeType(this);
        }
        catch (RegistryException e) {
            throw new DavException(400);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        try {
            if (shallow) {
                throw new DavException(400, "Shallow copy/move not supported");
            }
            this.registry.copy(this.path, destination.getResourcePath());
        }
        catch (RegistryException e) {
            throw new DavException(400, (Throwable)e);
        }
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatusResponse msr = new MultiStatusResponse(this.getHref(), null);
        for (DavProperty property : changeList) {
            try {
                this.getUnderlineResource().setProperty(property.getName().getName(), (String)property.getValue());
                msr.add(property, 200);
            }
            catch (Exception e) {
                e.printStackTrace();
                msr.add(property, 400);
            }
        }
        return msr;
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatusResponse msr = new MultiStatusResponse(this.getHref(), null);
        for (DavProperty property : setProperties) {
            try {
                this.getUnderlineResource().setProperty(property.getName().getName(), (String)property.getValue());
                msr.add(property, 200);
            }
            catch (Exception e) {
                e.printStackTrace();
                msr.add(property, 400);
            }
        }
        for (DavProperty property : setProperties) {
            try {
                this.getUnderlineResource().setProperty(property.getName().getName(), (String)property.getValue());
                msr.add(property, 200);
            }
            catch (Exception e) {
                e.printStackTrace();
                msr.add(property, 400);
            }
        }
        return msr;
    }

    public DavResourceFactory getFactory() {
        return this.resourceCache.getEnviorment().getResourceFactory();
    }

    public String getHref() {
        return new StringBuffer(this.resourceCache.getContextPath()).append("/registry/resourcewebdav").append(this.path).toString().replace(" ", "%20");
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public DavResourceIterator getMembers() {
        try {
            String[] childrenNames = ((CollectionImpl)this.getUnderlineResource()).getChildren();
            ArrayList<RegistryResource> childrenList = new ArrayList<RegistryResource>();
            for (String name : childrenNames) {
                RegistryResource registryResource = this.resourceCache.getRegistryResource(name);
                if ("true".equals(registryResource.getUnderlineResource().getProperty("registry.link"))) continue;
                childrenList.add(registryResource);
            }
            return new DavResourceIteratorImpl(childrenList);
        }
        catch (RegistryException e) {
            throw new RuntimeException(e);
        }
        catch (DavException e) {
            throw new RuntimeException(e);
        }
    }

    public long getModificationTime() {
        return this.getUnderlineResource().getLastModified().getTime();
    }

    public DavPropertySet getProperties() {
        final Properties properties = this.getUnderlineResource().getProperties();
        DavPropertySet davproperties = new DavPropertySet();
        for (final Object key : properties.keySet()) {
            davproperties.add(new DavProperty(){

                public Element toXml(Document document) {
                    return null;
                }

                public boolean isInvisibleInAllprop() {
                    return false;
                }

                public Object getValue() {
                    return properties.get(key);
                }

                public DavPropertyName getName() {
                    return DavPropertyName.create((String)((String)key));
                }
            });
        }
        for (DavProperty p : this.properties.values()) {
            davproperties.add(p);
        }
        return davproperties;
    }

    public DavProperty getProperty(final DavPropertyName name) {
        DavProperty property = this.properties.get(name);
        if (property != null) {
            return property;
        }
        return new DavProperty(){

            public Element toXml(Document document) {
                return null;
            }

            public boolean isInvisibleInAllprop() {
                return false;
            }

            public Object getValue() {
                return RegistryResource.this.getUnderlineResource().getProperty(name.getName());
            }

            public DavPropertyName getName() {
                return name;
            }
        };
    }

    public DavPropertyName[] getPropertyNames() {
        ArrayList<DavPropertyName> list = new ArrayList<DavPropertyName>();
        Iterator<Object> it = this.getUnderlineResource().getProperties().keySet().iterator();
        while (it.hasNext()) {
            list.add(DavPropertyName.create((String)((String)it.next())));
        }
        Iterator<DavPropertyName> it2 = this.properties.keySet().iterator();
        while (it2.hasNext()) {
            list.add(it2.next());
        }
        return list.toArray(new DavPropertyName[0]);
    }

    public DavSession getSession() {
        return this.resourceCache.getSession();
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY,PUT, DELETE, MOVE, LOCK, UNLOCK, BIND, REBIND, UNBIND";
    }

    public void spool(OutputContext outputContext) throws IOException {
        block6: {
            try {
                if (this.exists()) {
                    if (!this.isCollection()) {
                        InputStream in = this.getUnderLineResource().getContentStream();
                        OutputStream out = outputContext.getOutputStream();
                        if (null != out) {
                            int read;
                            byte[] buf = new byte[1024];
                            while ((read = in.read(buf)) >= 0) {
                                out.write(buf, 0, read);
                            }
                        }
                    }
                    break block6;
                }
                throw new IOException("Resource " + this.path + " does not exists");
            }
            catch (RegistryException e) {
                throw new IOException("Error writing resource " + this.path + ":" + e.getMessage());
            }
        }
    }

    public Resource getUnderLineResource() {
        return this.underLineResource;
    }

    public void setUnderLineResource(Resource underLineResource) {
        this.underLineResource = underLineResource;
    }

    private boolean isLocked(DavResource res) {
        ActiveLock lock = res.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            return false;
        }
        String[] sLockTokens = this.session.getLockTokens();
        for (int i = 0; i < sLockTokens.length; ++i) {
            if (!sLockTokens[i].equals(lock.getToken())) continue;
            return false;
        }
        return true;
    }
}

