/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.uddi.utils;

import java.rmi.RemoteException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.JUDDIApiImpl;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.api.impl.UDDIPublicationImpl;
import org.apache.juddi.api.impl.UDDISecurityImpl;
import org.apache.juddi.api_v3.Publisher;
import org.apache.juddi.api_v3.SavePublisher;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class UDDIUtil {
    private static final Log log = LogFactory.getLog(UDDIUtil.class);
    private static final String PUBLISHER_USER_ID = "wso2";
    private static final String PUBLISHER_PASSWORD = "wso2carbon";
    private static final String PUBLISHER_NAME = "wso2";
    private static final String ROOT_USER_ID = "root";
    private static final String ROOT_PASSWORD = "root";
    public static Map<String, String> businessKeyMap;
    private static UDDISecurityImpl security;
    private static UDDIPublicationImpl publish;
    private static UDDIInquiryImpl inquiry;
    private static AuthToken publisherAuthToken;

    public static BusinessDetail publishBusiness(BusinessEntity businessEntity) throws RegistryException {
        BusinessDetail businessDetail = null;
        try {
            SaveBusiness saveBusiness = new SaveBusiness();
            saveBusiness.getBusinessEntity().add(businessEntity);
            saveBusiness.setAuthInfo(UDDIUtil.getPublisherAuthToken().getAuthInfo());
            businessDetail = UDDIUtil.getUDDIPublishService().saveBusiness(saveBusiness);
        }
        catch (Exception e) {
            String msg = "Unable to publish the business entity";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return businessDetail;
    }

    public static ServiceDetail publishBusinessService(BusinessService businessService) throws RegistryException {
        SaveService saveService = new SaveService();
        saveService.getBusinessService().add(businessService);
        ServiceDetail serviceDetail = null;
        try {
            AuthToken authToken = UDDIUtil.getPublisherAuthToken();
            saveService.setAuthInfo(authToken.getAuthInfo());
            serviceDetail = UDDIUtil.getUDDIPublishService().saveService(saveService);
        }
        catch (Exception e) {
            String msg = "Unable to publish the business service";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return serviceDetail;
    }

    public static TModelDetail saveTModel(TModel tModel) throws RegistryException {
        SaveTModel saveTModel = new SaveTModel();
        saveTModel.getTModel().add(tModel);
        TModelDetail tModelDetail = null;
        try {
            AuthToken authToken = UDDIUtil.getPublisherAuthToken();
            saveTModel.setAuthInfo(authToken.getAuthInfo());
            tModelDetail = UDDIUtil.getUDDIPublishService().saveTModel(saveTModel);
        }
        catch (Exception e) {
            String msg = "Unable to save TModel in UDDI";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return tModelDetail;
    }

    public static BusinessList findBusiness(FindBusiness business) throws RegistryException {
        BusinessList businessList = null;
        try {
            businessList = UDDIUtil.getUDDIInquiryService().findBusiness(business);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while finding a business";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return businessList;
    }

    private static UDDISecurityImpl getUDDISecurityService() throws RegistryException {
        if (security == null) {
            security = new UDDISecurityImpl();
        }
        return security;
    }

    private static UDDIPublicationImpl getUDDIPublishService() throws RegistryException {
        if (publish == null) {
            publish = new UDDIPublicationImpl();
        }
        return publish;
    }

    private static UDDIInquiryImpl getUDDIInquiryService() throws RegistryException {
        if (inquiry == null) {
            inquiry = new UDDIInquiryImpl();
        }
        return inquiry;
    }

    private static void savePublisher() throws RegistryException {
        try {
            GetAuthToken authTokenRoot = new GetAuthToken();
            authTokenRoot.setUserID("root");
            authTokenRoot.setCred("root");
            AuthToken rootAuthToken = UDDIUtil.getUDDISecurityService().getAuthToken(authTokenRoot);
            Publisher publisher = new Publisher();
            publisher.setAuthorizedName("wso2");
            publisher.setPublisherName("wso2");
            SavePublisher savePublisher = new SavePublisher();
            savePublisher.getPublisher().add(publisher);
            savePublisher.setAuthInfo(rootAuthToken.getAuthInfo());
            JUDDIApiImpl juddiApi = new JUDDIApiImpl();
            juddiApi.savePublisher(savePublisher);
        }
        catch (Exception e) {
            String msg = "Unable to save the publisher";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    private static AuthToken getPublisherAuthToken() throws RegistryException {
        if (publisherAuthToken == null) {
            try {
                UDDIUtil.savePublisher();
                GetAuthToken publisherGetAuthToken = new GetAuthToken();
                publisherGetAuthToken.setUserID("wso2");
                publisherGetAuthToken.setCred(PUBLISHER_PASSWORD);
                UDDISecurityImpl security = new UDDISecurityImpl();
                publisherAuthToken = security.getAuthToken(publisherGetAuthToken);
            }
            catch (Exception e) {
                String msg = "Unable to get the publisher authentication token.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
        }
        return publisherAuthToken;
    }

    static {
        security = null;
        publish = null;
        inquiry = null;
        publisherAuthToken = null;
    }
}

