/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.uddi.internal;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.uddi.deployer.JUDDIJAXWSDeployer;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class JUDDIServiceComponent {
    private static final Log log = LogFactory.getLog(JUDDIServiceComponent.class);
    private static ConfigurationContext configContext;
    private static final String COMPONENTS = "components";
    private static final String PLUGINS = "plugins";
    private static final String REPOSITORY = "repository";
    private static final String ENABLE = "enable";
    private static final String UDDI_SYSTEM_PROPERTY = "uddi";
    JUDDIJAXWSDeployer uddiJAXWSDeployer;

    protected void activate(ComponentContext ctxt) {
        if (ENABLE.equals(System.getProperty(UDDI_SYSTEM_PROPERTY))) {
            this.deployUDDIService();
        }
    }

    private void deployUDDIService() {
        Deployer jaxwsDeployer = ((DeploymentEngine)configContext.getAxisConfiguration().getConfigurator()).getDeployer("servicejars", "jar");
        this.uddiJAXWSDeployer = new JUDDIJAXWSDeployer(jaxwsDeployer, configContext);
        File jaxwsService = this.findTheJAXWSService();
        if (jaxwsService != null) {
            DeploymentFileData deploymentFileData = new DeploymentFileData(jaxwsService);
            this.uddiJAXWSDeployer.deploy(deploymentFileData);
        } else {
            log.error((Object)"jUDDI Service Deployment failed");
        }
    }

    private File findTheJAXWSService() {
        String carbonPluginsDir = CarbonUtils.getCarbonHome() + File.separator + REPOSITORY + File.separator + COMPONENTS + File.separator + PLUGINS;
        File jaxwsService = null;
        File pluginsDir = new File(carbonPluginsDir);
        String[] children = pluginsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith("juddi") && name.toLowerCase().endsWith(".jar");
            }
        });
        if (children == null) {
            log.error((Object)"Couldn't find jUDDI JAX-WS service");
        } else if (children.length > 1) {
            log.error((Object)"Couldn't find the correct jUDDI JAX-WS service, there are more than one juddi bundles in pluggins.");
        } else {
            jaxwsService = new File(carbonPluginsDir + File.separator + children[0]);
        }
        return jaxwsService;
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        JUDDIServiceComponent.updateConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        JUDDIServiceComponent.updateConfigContext(null);
    }

    private static void updateConfigContext(ConfigurationContext context) {
        configContext = context;
    }
}

