/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.uddi.deployer;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMapManager;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.framework.JAXWSDeployer;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JUDDIJAXWSDeployer
extends JAXWSDeployer {
    private static final Log log = LogFactory.getLog(JUDDIJAXWSDeployer.class);
    private Deployer jaxwsDeployer;
    private ConfigurationContext configurationContext;

    public JUDDIJAXWSDeployer(Deployer jaxwsDeployer, ConfigurationContext configurationContext) {
        this.jaxwsDeployer = jaxwsDeployer;
        this.configurationContext = configurationContext;
    }

    public void deploy(DeploymentFileData deploymentFileData) {
        try {
            String groupName = deploymentFileData.getName();
            URL location = deploymentFileData.getFile().toURL();
            if (JUDDIJAXWSDeployer.isJar((File)deploymentFileData.getFile())) {
                log.info((Object)("Deploying artifact : " + deploymentFileData.getAbsolutePath()));
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(deploymentFileData.getFile().toURL());
                List classList = Utils.getListOfClasses((DeploymentFileData)deploymentFileData);
                AxisServiceGroup serviceGroup = this.deployClasses(groupName, location, Thread.currentThread().getContextClassLoader(), classList);
                if (serviceGroup == null) {
                    String msg = "Error:\n No @WebService annotated service implementations found in the jar: " + location.toString() + ". Service deployment failed.";
                    log.error((Object)msg);
                    this.configurationContext.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                }
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage());
        }
        catch (DeploymentException e) {
            log.error((Object)e.getMessage());
        }
        catch (Throwable t) {
            this.storeFaultyService(deploymentFileData, t);
        }
    }

    protected AxisServiceGroup deployClasses(String groupName, URL location, ClassLoader classLoader, List<String> classList) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        ArrayList<AxisService> axisServiceList = new ArrayList<AxisService>();
        for (String className : classList) {
            AxisService axisService;
            Class pojoClass;
            try {
                pojoClass = Loader.loadClass((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)className);
            }
            catch (Exception e) {
                continue;
            }
            catch (Throwable t) {
                continue;
            }
            WebService wsAnnotation = pojoClass.getAnnotation(WebService.class);
            WebServiceProvider wspAnnotation = null;
            if (wsAnnotation == null) {
                wspAnnotation = pojoClass.getAnnotation(WebServiceProvider.class);
            }
            if (wsAnnotation == null && wspAnnotation == null || pojoClass.isInterface() || (axisService = this.createAxisService(classLoader, className, location)) == null) continue;
            log.info((Object)("Deploying JAXWS annotated class " + className + " as a service - " + axisService.getName()));
            axisServiceList.add(axisService);
        }
        int size = axisServiceList.size();
        if (size <= 0) {
            return null;
        }
        AxisServiceGroup serviceGroup = new AxisServiceGroup();
        serviceGroup.setServiceGroupName(groupName);
        for (AxisService axisService : axisServiceList) {
            axisService.setName(axisService.getName());
            serviceGroup.addService(axisService);
        }
        this.configurationContext.getAxisConfiguration().addServiceGroup(serviceGroup);
        this.configureAddressing(serviceGroup);
        return serviceGroup;
    }

    protected void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.configurationContext.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    protected AxisService createAxisService(ClassLoader classLoader, String className, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        AxisService axisService;
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Class pojoClass = Loader.loadClass((ClassLoader)loader, (String)className);
        try {
            axisService = DescriptionFactory.createAxisService((Class)pojoClass, (ConfigurationContext)this.configurationContext);
        }
        catch (Throwable t) {
            log.error((Object)("Exception creating Axis Service : " + t.getCause()), t);
            return null;
        }
        if (axisService != null) {
            Iterator operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)operations.next();
                if (axisOperation.getMessageReceiver() != null) continue;
                axisOperation.setMessageReceiver((MessageReceiver)new JAXWSMessageReceiver());
            }
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            axisService.setClassLoader(loader);
            axisService.addParameter(new Parameter("CACHE_CLASSLOADER", (Object)loader));
        }
        return axisService;
    }

    private void configureAddressing(AxisServiceGroup serviceGroup) {
        EndpointContextMap map = (EndpointContextMap)this.configurationContext.getProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap");
        if (map == null) {
            map = EndpointContextMapManager.getEndpointContextMap();
            this.configurationContext.setProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap", (Object)map);
        }
        Iterator iterator = serviceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService axisService = (AxisService)iterator.next();
            Parameter param = axisService.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            QName serviceName = ed.getServiceQName();
            QName portName = ed.getPortQName();
            EndpointKey key = new EndpointKey(serviceName, portName);
            map.put((Object)key, (Object)axisService);
        }
    }

    public void undeploy(String fileName) {
        try {
            this.jaxwsDeployer.undeploy(fileName);
        }
        catch (DeploymentException e) {
            log.error((Object)e.getMessage());
        }
    }
}

