/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.task.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistryTaskServiceComponent {
    private static Log log = LogFactory.getLog(RegistryTaskServiceComponent.class);
    private static final String REGISTRY_TASK_MANAGER = "registryTasks";

    protected void activate(ComponentContext context) {
        log.debug((Object)"Registry Tasks bundle is activated ");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Registry Tasks bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Task Service");
        }
        try {
            TaskManager taskManager = null;
            SuperTenantCarbonContext.startTenantFlow();
            try {
                SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                taskManager = taskService.getTaskManager(REGISTRY_TASK_MANAGER);
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
            if (taskManager != null) {
                this.registerTasks(taskManager);
                List allTasks = taskManager.getAllTasks();
                for (TaskInfo task : allTasks) {
                    taskManager.rescheduleTask(task.getName());
                }
            } else {
                log.warn((Object)"Unable to obtain an instance of a task manager");
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Unable to schedule tasks", e);
        }
    }

    private void registerTasks(TaskManager taskManager) throws TaskException {
        File registryXML;
        String configPath = CarbonUtils.getRegistryXMLPath();
        if (configPath != null && (registryXML = new File(configPath)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(registryXML);
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)fileInputStream);
                OMElement configElement = builder.getDocumentElement();
                OMElement taskElement = configElement.getFirstChildWithName(new QName("tasks"));
                if (taskElement != null) {
                    Iterator tasks = taskElement.getChildrenWithName(new QName("task"));
                    while (tasks.hasNext()) {
                        OMElement task = (OMElement)tasks.next();
                        String cronExpression = task.getFirstChildWithName(new QName("trigger")).getAttributeValue(new QName("cron"));
                        if (cronExpression == null) {
                            log.warn((Object)"Only Cron-based triggers are supported right now");
                            continue;
                        }
                        TaskInfo.TriggerInfo trigger = new TaskInfo.TriggerInfo(cronExpression);
                        String name = task.getAttributeValue(new QName("name"));
                        String clazz = task.getAttributeValue(new QName("class"));
                        if (name == null) {
                            name = clazz.substring(clazz.lastIndexOf(".") + 1);
                        }
                        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
                        Iterator properties = task.getChildrenWithName(new QName("property"));
                        while (properties.hasNext()) {
                            OMElement property = (OMElement)properties.next();
                            propertyMap.put(property.getAttributeValue(new QName("key")), property.getAttributeValue(new QName("value")));
                        }
                        taskManager.registerTask(new TaskInfo(name, clazz, propertyMap, trigger));
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to parse registry.xml", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Unable to read registry.xml", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetTaskService(TaskService taskService) {
        try {
            TaskManager taskManager = null;
            SuperTenantCarbonContext.startTenantFlow();
            try {
                SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                taskManager = taskService.getTaskManager(REGISTRY_TASK_MANAGER);
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
            if (taskManager != null) {
                for (TaskInfo taskInfo : taskManager.getAllTasks()) {
                    taskManager.deleteTask(taskInfo.getName());
                }
            }
        }
        catch (TaskException e) {
            log.warn((Object)"Unable to clean-up scheduled tasks", (Throwable)e);
        }
    }
}

