/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.social.impl.people.relationship;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.people.relationship.RelationshipManager;
import org.wso2.carbon.registry.social.impl.internal.SocialDSComponent;

public class RelationshipManagerImpl
implements RelationshipManager {
    private static Log log = LogFactory.getLog(RelationshipManagerImpl.class);
    private Registry registry = null;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() throws RegistryException {
        if (this.registry != null) {
            return this.registry;
        }
        return SocialDSComponent.getRegistry();
    }

    public boolean requestRelationship(String viewer, String owner) throws SocialDataException {
        boolean result = false;
        if (viewer != null && owner != null && !viewer.trim().equals("") && !owner.trim().equals("")) {
            try {
                this.registry = this.getRegistry();
                String resourcePath = "/users/" + owner + "/pendingRequests";
                Object ownerResource = this.registry.resourceExists(resourcePath) ? this.registry.get(resourcePath) : this.registry.newCollection();
                ownerResource.addProperty("pendingRequests", viewer);
                this.registry.put(resourcePath, (Resource)ownerResource);
                result = true;
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SocialDataException("Error while requesting relationship from " + viewer + " to " + owner, (Throwable)e);
            }
        }
        return result;
    }

    public String getRelationshipStatus(String viewer, String owner) throws SocialDataException {
        if (viewer == null || owner == null || viewer.trim().equals("") || owner.trim().equals("")) {
            return null;
        }
        if (owner.equals(viewer)) {
            return "self";
        }
        try {
            List property;
            String resourcePath;
            this.registry = this.getRegistry();
            String ownerPath = "/users/" + owner;
            String viewerPath = "/users/" + viewer;
            if (this.registry.getAssociations(viewerPath, "FRIENDSHIP") != null) {
                Association[] friends;
                for (Association data : friends = this.registry.getAssociations(viewerPath, "FRIENDSHIP")) {
                    if (!data.getDestinationPath().equals(ownerPath)) continue;
                    return "friend";
                }
            }
            if (this.registry.resourceExists(resourcePath = "/users/" + owner + "/pendingRequests") && (property = this.registry.get(resourcePath).getPropertyValues("pendingRequests")) != null && property.contains(viewer)) {
                return "requestpending";
            }
            resourcePath = "/users/" + viewer + "/pendingRequests";
            if (this.registry.resourceExists(resourcePath) && (property = this.registry.get(resourcePath).getPropertyValues("pendingRequests")) != null && property.contains(owner)) {
                return "requestreceived";
            }
            return "none";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving relationship status between users " + viewer + " and " + owner, (Throwable)e);
        }
    }

    public String[] getPendingRelationshipRequests(String owner) throws SocialDataException {
        String[] result = null;
        try {
            Resource registryResource;
            List pendingRequests;
            this.registry = this.getRegistry();
            String resourcePath = "/users/" + owner + "/pendingRequests";
            if (this.registry.resourceExists(resourcePath) && (pendingRequests = (registryResource = this.registry.get(resourcePath)).getPropertyValues("pendingRequests")) != null) {
                result = new String[pendingRequests.size()];
                result = pendingRequests.toArray(result);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving pending relationship requests for user " + owner, (Throwable)e);
        }
        return result;
    }

    public boolean acceptRelationshipRequest(String viewer, String owner) throws SocialDataException {
        try {
            this.registry = this.getRegistry();
            String viewerResourcePath = "/users/" + viewer;
            String ownerResourcePath = "/users/" + owner;
            if (!this.registry.resourceExists(viewerResourcePath)) {
                this.registry.put(viewerResourcePath, (Resource)this.registry.newCollection());
            }
            if (!this.registry.resourceExists(ownerResourcePath)) {
                this.registry.put(ownerResourcePath, (Resource)this.registry.newCollection());
            }
            this.registry.addAssociation(viewerResourcePath, ownerResourcePath, "FRIENDSHIP");
            this.registry.addAssociation(ownerResourcePath, viewerResourcePath, "FRIENDSHIP");
            viewerResourcePath = viewerResourcePath + "/pendingRequests";
            if (this.registry.resourceExists(viewerResourcePath)) {
                Resource resource = this.registry.get(viewerResourcePath);
                resource.removePropertyValue("pendingRequests", owner);
                this.registry.put(viewerResourcePath, resource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while accepting relationship request from " + owner + " to " + viewer, (Throwable)e);
        }
        return true;
    }

    public String[] getRelationshipList(String loggedUser) throws SocialDataException {
        String[] newResult = null;
        int index = 0;
        try {
            this.registry = this.getRegistry();
            String profilePath = "/users/" + loggedUser;
            Association[] relationships = this.registry.getAssociations(profilePath, "FRIENDSHIP");
            if (relationships != null) {
                String[] result = new String[relationships.length];
                for (Association relation : relationships) {
                    if (!relation.getSourcePath().equals(profilePath) || relation.getDestinationPath() == null) continue;
                    result[index++] = this.getUserName(relation.getDestinationPath());
                }
                newResult = new String[index];
                System.arraycopy(result, 0, newResult, 0, index);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving relationship list for user " + loggedUser, (Throwable)e);
        }
        return newResult;
    }

    private String getUserName(String profilePath) throws SocialDataException {
        String userName = profilePath.substring(7);
        return userName;
    }

    public boolean ignoreRelationship(String viewer, String owner) throws SocialDataException {
        boolean result = false;
        if (viewer != null && owner != null && !viewer.trim().equals("") && !owner.trim().equals("")) {
            try {
                this.registry = this.getRegistry();
                String resourcePath = "/users/" + viewer + "/pendingRequests";
                if (this.registry.resourceExists(resourcePath)) {
                    Resource ownerResource = this.registry.get(resourcePath);
                    if (ownerResource.getPropertyValues("pendingRequests").indexOf(owner) >= 0) {
                        ownerResource.removePropertyValue("pendingRequests", owner);
                        this.registry.put(resourcePath, ownerResource);
                    }
                    result = true;
                }
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SocialDataException("Error while ignoring relationship request from " + owner + " to " + viewer, (Throwable)e);
            }
        }
        return result;
    }

    public boolean removeRelationship(String owner, String viewer) throws SocialDataException {
        try {
            this.registry = this.getRegistry();
            String viewerResourcePath = "/users/" + viewer;
            String ownerResourcePath = "/users/" + owner;
            if (!this.registry.resourceExists(viewerResourcePath)) {
                this.registry.put(viewerResourcePath, (Resource)this.registry.newCollection());
            }
            if (!this.registry.resourceExists(ownerResourcePath)) {
                this.registry.put(ownerResourcePath, (Resource)this.registry.newCollection());
            }
            this.registry.removeAssociation(viewerResourcePath, ownerResourcePath, "FRIENDSHIP");
            this.registry.removeAssociation(ownerResourcePath, viewerResourcePath, "FRIENDSHIP");
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while removing relationship between " + owner + " and " + viewer, (Throwable)e);
        }
        return true;
    }
}

