/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.servlet.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.abdera.protocol.server.servlet.AbderaServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.registry.app.ResourceServlet;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.uddi.servlet.JUDDIRegistryServlet;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistryAtomServiceComponent {
    private static Log log = LogFactory.getLog(RegistryAtomServiceComponent.class);
    private static final String ENABLE = "enable";
    private static final String UDDI_SYSTEM_PROPERTY = "uddi";
    private RegistryService registryService = null;
    private HttpService httpService = null;

    protected void activate(ComponentContext context) {
        try {
            this.registerServlet(context.getBundleContext());
            log.debug((Object)"******* Registry APP bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate Registry APP bundle ******* ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.httpService.unregister("/registry/atom");
        this.httpService.unregister("/registry/tags");
        this.httpService.unregister("/registry/resource");
        if (ENABLE.equals(System.getProperty(UDDI_SYSTEM_PROPERTY))) {
            this.httpService.unregister("/juddiv3");
        }
        log.debug((Object)"******* Registry APP bundle is deactivated ******* ");
    }

    public void registerServlet(BundleContext bundleContext) throws Exception {
        if (this.registryService == null) {
            String msg = "Unable to Register Servlet. Registry Service Not Found.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        if (!CarbonUtils.isRemoteRegistry()) {
            Hashtable<String, String> servletParam = new Hashtable<String, String>(2);
            ((Dictionary)servletParam).put("org.apache.abdera.protocol.server.Provider", "org.wso2.carbon.registry.app.RegistryProvider");
            this.httpService.registerServlet("/registry/atom", (Servlet)new AbderaServlet(), servletParam, defaultHttpContext);
            this.httpService.registerServlet("/registry/tags", (Servlet)new AbderaServlet(), servletParam, defaultHttpContext);
        }
        if (ENABLE.equals(System.getProperty(UDDI_SYSTEM_PROPERTY))) {
            this.httpService.registerServlet("/juddiv3", (Servlet)new JUDDIRegistryServlet(), null, defaultHttpContext);
        }
        this.httpService.registerServlet("/registry/resource", (Servlet)new ResourceServlet(), null, defaultHttpContext);
    }

    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }
}

