/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.search.stub.SearchAdminServiceStub;
import org.wso2.carbon.registry.search.stub.beans.xsd.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.stub.beans.xsd.ArrayOfString;
import org.wso2.carbon.registry.search.stub.beans.xsd.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.stub.beans.xsd.MediaTypeValueList;
import org.wso2.carbon.registry.search.stub.beans.xsd.SearchResultsBean;
import org.wso2.carbon.registry.search.stub.common.xsd.ResourceData;
import org.wso2.carbon.registry.search.ui.Utils;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SearchServiceClient {
    private static final Log log = LogFactory.getLog(SearchServiceClient.class);
    private SearchAdminServiceStub stub;
    private String epr;

    public SearchServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "SearchAdminService";
        try {
            this.stub = new SearchAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate search service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public SearchResultsBean getSearchResults(HttpServletRequest request) throws Exception {
        String searchType = (String)Utils.getParameter(request, "searchType");
        String criteria = (String)Utils.getParameter(request, "criteria");
        SearchResultsBean bean = null;
        try {
            bean = this.stub.getSearchResults(searchType, criteria);
            if (bean.getResourceDataList() == null) {
                bean.setResourceDataList(new ResourceData[0]);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get search results from the search service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
        return bean;
    }

    public AdvancedSearchResultsBean getAdvancedSearchResults(HttpServletRequest request) throws Exception {
        CustomSearchParameterBean paramterBean = this.getSearchParameterBeanFromRequest(request);
        AdvancedSearchResultsBean bean = null;
        try {
            bean = this.stub.getAdvancedSearchResults(paramterBean);
            if (bean.getResourceDataList() == null) {
                bean.setResourceDataList(new ResourceData[0]);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get advanced search results from the search service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
        return bean;
    }

    private CustomSearchParameterBean getSearchParameterBeanFromRequest(HttpServletRequest request) {
        CustomSearchParameterBean paramterBean = new CustomSearchParameterBean();
        try {
            int i;
            String s = request.getParameter("parameterList");
            String[] tempList = s.split("\\|");
            String[][] parameterList = new String[tempList.length][];
            ArrayOfString[] arrayOfStrings = new ArrayOfString[tempList.length];
            for (i = 0; i < tempList.length; ++i) {
                parameterList[i] = tempList[i].split("\\^", 2);
            }
            for (i = 0; i < parameterList.length; ++i) {
                ArrayOfString arr = new ArrayOfString();
                arr.addArray(parameterList[i][0]);
                if ("null".equals(parameterList[i][1])) {
                    arr.addArray("");
                } else {
                    arr.addArray(parameterList[i][1]);
                }
                arrayOfStrings[i] = arr;
            }
            paramterBean.setParameterValues(arrayOfStrings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paramterBean;
    }

    public MediaTypeValueList getMediaTypeParameterList(HttpServletRequest request) throws Exception {
        String mediaType = request.getParameter("mediaType");
        mediaType = mediaType.replace(" ", "+");
        return this.stub.getMediaTypeSearch(mediaType);
    }

    public void saveSearchFilter(HttpServletRequest request, String filterName) throws Exception {
        CustomSearchParameterBean bean = this.getSearchParameterBeanFromRequest(request);
        try {
            this.stub.saveAdvancedSearchFilter(bean, filterName);
        }
        catch (Exception e) {
            String msg = "Failed to save search filter using the search service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public void deleteSearchFilter(String filterName) throws Exception {
        this.stub.deleteFilter(filterName);
    }

    public String[] getSavedFilters() throws Exception {
        try {
            return this.stub.getSavedFilters();
        }
        catch (Exception e) {
            String msg = "Failed to get search filter names from the search service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public CustomSearchParameterBean getAdvancedSearchFilter(String filterName) throws Exception {
        try {
            return this.stub.getAdvancedSearchFilter(filterName);
        }
        catch (Exception e) {
            String msg = "Failed to get search filter from the search service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }
}

