/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class UpdateTextContentUtil {
    private static final Log log = LogFactory.getLog(UpdateTextContentUtil.class);

    public static void updateTextContent(String path, String contentText, Registry registry) throws Exception {
        try {
            Resource resource = registry.get(path);
            String mediaType = resource.getMediaType();
            if (resource.getProperty("registry.link") != null && ("application/wsdl+xml".equals(mediaType) || "application/xsd+xml".equals(mediaType))) {
                String description = resource.getDescription();
                Properties properties = (Properties)resource.getProperties().clone();
                resource = registry.newResource();
                resource.setMediaType(mediaType);
                resource.setDescription(description);
                resource.setProperties(properties);
            }
            resource.setContent((Object)RegistryUtils.encodeString((String)contentText));
            registry.put(path, resource);
            resource.discard();
        }
        catch (RegistryException e) {
            String msg = "Could not update the content of the resource " + path + ". Caused by: " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

