/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.beans.PermissionBean;
import org.wso2.carbon.registry.resource.beans.PermissionEntry;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class PermissionUtil {
    private static final Log log = LogFactory.getLog(PermissionUtil.class);

    public static PermissionBean getPermissions(UserRegistry userRegistry, String path) throws Exception {
        ResourcePath resourcePath = new ResourcePath(path);
        String userName = userRegistry.getUserName();
        PermissionBean permissionsBean = new PermissionBean();
        permissionsBean.setPathWithVersion(resourcePath.getPathWithVersion());
        permissionsBean.setVersionView(!resourcePath.isCurrentVersion());
        UserRealm userRealm = userRegistry.getUserRealm();
        String[] userNames = userRealm.getUserStoreManager().listUsers("*", 100);
        ArrayList<String> filteredUserNames = new ArrayList<String>();
        RealmConfiguration realmConfig = userRealm.getRealmConfiguration();
        String systemUserName = "wso2.system.user";
        String adminUserName = realmConfig.getAdminUserName();
        for (String userN : userNames) {
            if (userN.equals(adminUserName) || userN.equals(systemUserName)) continue;
            filteredUserNames.add(userN);
        }
        userNames = filteredUserNames.toArray(new String[filteredUserNames.size()]);
        permissionsBean.setUserNames(userNames);
        String[] roleNames = userRealm.getUserStoreManager().getRoleNames();
        ArrayList<String> filteredRoleNames = new ArrayList<String>();
        String adminRoleName = realmConfig.getAdminRoleName();
        for (String roleN : roleNames) {
            if (roleN.equals(adminRoleName)) continue;
            filteredRoleNames.add(roleN);
        }
        roleNames = filteredRoleNames.toArray(new String[filteredRoleNames.size()]);
        permissionsBean.setRoleNames(roleNames);
        String authorizationPath = path;
        if (path.indexOf("?") > 0) {
            authorizationPath = path.split("\\?")[0];
        } else if (path.indexOf(";") > 0) {
            authorizationPath = path.split("\\;")[0];
        }
        if (UserUtil.isPutAllowed((String)userName, (String)authorizationPath, (UserRegistry)userRegistry)) {
            permissionsBean.setPutAllowed(true);
        } else {
            permissionsBean.setPutAllowed(false);
        }
        if (UserUtil.isDeleteAllowed((String)userName, (String)authorizationPath, (UserRegistry)userRegistry)) {
            permissionsBean.setDeleteAllowed(true);
        } else {
            permissionsBean.setDeleteAllowed(false);
        }
        if (UserUtil.isAuthorizeAllowed((String)userName, (String)authorizationPath, (UserRegistry)userRegistry)) {
            permissionsBean.setAuthorizeAllowed(true);
        } else {
            permissionsBean.setAuthorizeAllowed(false);
        }
        permissionsBean.setUserPermissions(PermissionUtil.getUserPermissions(userRealm, path));
        permissionsBean.setRolePermissions(PermissionUtil.getRolePermissions(userRealm, path));
        return permissionsBean;
    }

    private static PermissionEntry[] getUserPermissions(UserRealm userRealm, String path) throws UserStoreException {
        String[] adUsers;
        String[] aaUsers;
        String[] ddUsers;
        String[] daUsers;
        String[] wdUsers;
        String[] waUsers;
        String[] rdUsers;
        String[] raUsers;
        HashMap<String, PermissionEntry> userPermissionMap = new HashMap<String, PermissionEntry>();
        AuthorizationManager authorizer = userRealm.getAuthorizationManager();
        RealmConfiguration realmConfig = userRealm.getRealmConfiguration();
        String systemUserName = "wso2.system.user";
        String adminUserName = realmConfig.getAdminUserName();
        for (String raUser : raUsers = authorizer.getExplicitlyAllowedUsersForResource(path, "http://www.wso2.org/projects/registry/actions/get")) {
            PermissionEntry permission;
            if (raUser.equals(systemUserName) || raUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(raUser)) {
                permission = (PermissionEntry)userPermissionMap.get(raUser);
                permission.setReadAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(raUser);
            permission.setReadAllow(true);
            userPermissionMap.put(raUser, permission);
        }
        for (String rdUser : rdUsers = authorizer.getExplicitlyDeniedUsersForResource(path, "http://www.wso2.org/projects/registry/actions/get")) {
            PermissionEntry permission;
            if (rdUser.equals(systemUserName) || rdUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(rdUser)) {
                permission = (PermissionEntry)userPermissionMap.get(rdUser);
                permission.setReadDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(rdUser);
            permission.setReadDeny(true);
            userPermissionMap.put(rdUser, permission);
        }
        for (String waUser : waUsers = authorizer.getExplicitlyAllowedUsersForResource(path, "http://www.wso2.org/projects/registry/actions/add")) {
            PermissionEntry permission;
            if (waUser.equals(systemUserName) || waUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(waUser)) {
                permission = (PermissionEntry)userPermissionMap.get(waUser);
                permission.setWriteAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(waUser);
            permission.setWriteAllow(true);
            userPermissionMap.put(waUser, permission);
        }
        for (String wdUser : wdUsers = authorizer.getExplicitlyDeniedUsersForResource(path, "http://www.wso2.org/projects/registry/actions/add")) {
            PermissionEntry permission;
            if (wdUser.equals(systemUserName) || wdUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(wdUser)) {
                permission = (PermissionEntry)userPermissionMap.get(wdUser);
                permission.setWriteDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(wdUser);
            permission.setWriteDeny(true);
            userPermissionMap.put(wdUser, permission);
        }
        for (String daUser : daUsers = authorizer.getExplicitlyAllowedUsersForResource(path, "http://www.wso2.org/projects/registry/actions/delete")) {
            PermissionEntry permission;
            if (daUser.equals(systemUserName) || daUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(daUser)) {
                permission = (PermissionEntry)userPermissionMap.get(daUser);
                permission.setDeleteAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(daUser);
            permission.setDeleteAllow(true);
            userPermissionMap.put(daUser, permission);
        }
        for (String ddUser : ddUsers = authorizer.getExplicitlyDeniedUsersForResource(path, "http://www.wso2.org/projects/registry/actions/delete")) {
            PermissionEntry permission;
            if (ddUser.equals(systemUserName) || ddUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(ddUser)) {
                permission = (PermissionEntry)userPermissionMap.get(ddUser);
                permission.setDeleteDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(ddUser);
            permission.setDeleteDeny(true);
            userPermissionMap.put(ddUser, permission);
        }
        for (String aaUser : aaUsers = authorizer.getExplicitlyAllowedUsersForResource(path, "authorize")) {
            PermissionEntry permission;
            if (aaUser.equals(systemUserName) || aaUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(aaUser)) {
                permission = (PermissionEntry)userPermissionMap.get(aaUser);
                permission.setAuthorizeAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(aaUser);
            permission.setAuthorizeAllow(true);
            userPermissionMap.put(aaUser, permission);
        }
        for (String adUser : adUsers = authorizer.getExplicitlyDeniedUsersForResource(path, "authorize")) {
            PermissionEntry permission;
            if (adUser.equals(systemUserName) || adUser.equals(adminUserName)) continue;
            if (userPermissionMap.containsKey(adUser)) {
                permission = (PermissionEntry)userPermissionMap.get(adUser);
                permission.setAuthorizeDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(adUser);
            permission.setAuthorizeDeny(true);
            userPermissionMap.put(adUser, permission);
        }
        ArrayList permissionEntryList = new ArrayList(userPermissionMap.values());
        return permissionEntryList.toArray(new PermissionEntry[permissionEntryList.size()]);
    }

    private static PermissionEntry[] getRolePermissions(UserRealm userRealm, String path) throws UserStoreException {
        String[] adRoles;
        String[] aaRoles;
        String[] ddRoles;
        String[] daRoles;
        String[] wdRoles;
        String[] waRoles;
        String[] rdRoles;
        String[] raRoles;
        HashMap<String, PermissionEntry> rolePermissionMap = new HashMap<String, PermissionEntry>();
        AuthorizationManager authorizer = userRealm.getAuthorizationManager();
        RealmConfiguration realmConfig = userRealm.getRealmConfiguration();
        String adminRoleName = realmConfig.getAdminRoleName();
        for (String raRole : raRoles = authorizer.getAllowedRolesForResource(path, "http://www.wso2.org/projects/registry/actions/get")) {
            PermissionEntry permission;
            if (raRole.equals(adminRoleName)) continue;
            if (rolePermissionMap.containsKey(raRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(raRole);
                permission.setReadAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(raRole);
            permission.setReadAllow(true);
            rolePermissionMap.put(raRole, permission);
        }
        for (String rdRole : rdRoles = authorizer.getDeniedRolesForResource(path, "http://www.wso2.org/projects/registry/actions/get")) {
            PermissionEntry permission;
            if (rolePermissionMap.containsKey(rdRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(rdRole);
                permission.setReadDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(rdRole);
            permission.setReadDeny(true);
            rolePermissionMap.put(rdRole, permission);
        }
        for (String waRole : waRoles = authorizer.getAllowedRolesForResource(path, "http://www.wso2.org/projects/registry/actions/add")) {
            PermissionEntry permission;
            if (waRole.equals(adminRoleName)) continue;
            if (rolePermissionMap.containsKey(waRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(waRole);
                permission.setWriteAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(waRole);
            permission.setWriteAllow(true);
            rolePermissionMap.put(waRole, permission);
        }
        for (String wdRole : wdRoles = authorizer.getDeniedRolesForResource(path, "http://www.wso2.org/projects/registry/actions/add")) {
            PermissionEntry permission;
            if (rolePermissionMap.containsKey(wdRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(wdRole);
                permission.setWriteDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(wdRole);
            permission.setWriteDeny(true);
            rolePermissionMap.put(wdRole, permission);
        }
        for (String daRole : daRoles = authorizer.getAllowedRolesForResource(path, "http://www.wso2.org/projects/registry/actions/delete")) {
            PermissionEntry permission;
            if (daRole.equals(adminRoleName)) continue;
            if (rolePermissionMap.containsKey(daRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(daRole);
                permission.setDeleteAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(daRole);
            permission.setDeleteAllow(true);
            rolePermissionMap.put(daRole, permission);
        }
        for (String ddRole : ddRoles = authorizer.getDeniedRolesForResource(path, "http://www.wso2.org/projects/registry/actions/delete")) {
            PermissionEntry permission;
            if (rolePermissionMap.containsKey(ddRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(ddRole);
                permission.setDeleteDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(ddRole);
            permission.setDeleteDeny(true);
            rolePermissionMap.put(ddRole, permission);
        }
        for (String aaRole : aaRoles = authorizer.getAllowedRolesForResource(path, "authorize")) {
            PermissionEntry permission;
            if (aaRole.equals(adminRoleName)) continue;
            if (rolePermissionMap.containsKey(aaRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(aaRole);
                permission.setAuthorizeAllow(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(aaRole);
            permission.setAuthorizeAllow(true);
            rolePermissionMap.put(aaRole, permission);
        }
        for (String adRole : adRoles = authorizer.getDeniedRolesForResource(path, "authorize")) {
            PermissionEntry permission;
            if (rolePermissionMap.containsKey(adRole)) {
                permission = (PermissionEntry)rolePermissionMap.get(adRole);
                permission.setAuthorizeDeny(true);
                continue;
            }
            permission = new PermissionEntry();
            permission.setUserName(adRole);
            permission.setAuthorizeDeny(true);
            rolePermissionMap.put(adRole, permission);
        }
        ArrayList permissionEntryList = new ArrayList(rolePermissionMap.values());
        return permissionEntryList.toArray(new PermissionEntry[permissionEntryList.size()]);
    }
}

