/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ImportResourceUtil {
    private static final Log log = LogFactory.getLog(ImportResourceUtil.class);

    public static void importResource(String parentPath, String resourceName, String mediaType, String description, String fetchURL, String symlinkLocation, UserRegistry userRegistry) throws Exception {
        String resourcePath = "/".equals(parentPath) ? "/" + resourceName : parentPath + "/" + resourceName;
        try {
            Resource metadataResource = userRegistry.newResource();
            metadataResource.setMediaType(mediaType);
            metadataResource.setDescription(description);
            if (symlinkLocation != null) {
                if (!symlinkLocation.endsWith("/")) {
                    symlinkLocation = symlinkLocation + "/";
                }
                metadataResource.setProperty("SymlinkPropertyName", symlinkLocation);
            }
            userRegistry.importResource(resourcePath, fetchURL, metadataResource);
            metadataResource.discard();
        }
        catch (RegistryException e) {
            String msg = "Failed to import resource from the URL " + fetchURL + " to path " + resourcePath + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

