/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GetTextContentUtil {
    private static final Log log = LogFactory.getLog(GetTextContentUtil.class);

    public static String getTextContent(String path, Registry registry) throws Exception {
        try {
            Resource resource = registry.get(path);
            byte[] content = (byte[])resource.getContent();
            String contentString = "";
            if (content != null) {
                contentString = RegistryUtils.decodeBytes((byte[])content);
            }
            resource.discard();
            return contentString;
        }
        catch (RegistryException e) {
            String msg = "Could not get the content of the resource " + path + ". Caused by: " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

