/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.beans.ResourceTreeEntryBean;

public class GetResourceTreeEntryUtil {
    private static final Log log = LogFactory.getLog(GetResourceTreeEntryUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResourceTreeEntryBean getResourceTreeEntry(String resourcePath, UserRegistry registry) throws Exception {
        ResourceTreeEntryBean bean = new ResourceTreeEntryBean();
        try {
            Resource resource = null;
            try {
                try {
                    if (!registry.resourceExists(resourcePath)) {
                        ResourceTreeEntryBean resourceTreeEntryBean = null;
                        if (resource != null) return resourceTreeEntryBean;
                        return null;
                    }
                    resource = registry.get(resourcePath);
                    if (resource == null) {
                        throw new Exception();
                    }
                    if (resource.getProperty("registry.absent") != null) {
                        throw new Exception();
                    }
                    if (resource == null) {
                        return null;
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"[ERROR] An exception occured: ", (Throwable)e);
                    }
                    if ((resource = null) == null) {
                        return null;
                    }
                }
            }
            catch (Throwable throwable) {
                if (resource != null) throw throwable;
                return null;
            }
            if (resource.getProperty("registry.link") != null) {
                if (resource.getProperty("registry.realpath") != null) {
                    bean.setSymlink("remotelink");
                } else {
                    bean.setSymlink("symlink");
                }
            } else {
                bean.setSymlink(null);
            }
            if (resource instanceof Collection) {
                bean.setCollection(true);
                String[] children = ((Collection)resource).getChildren();
                ArrayList<String> filteredChilds = new ArrayList<String>();
                for (String child : children) {
                    if (!registry.resourceExists(child)) continue;
                    filteredChilds.add(child);
                }
                String[] filteredChildArr = filteredChilds.toArray(new String[filteredChilds.size()]);
                bean.setChildren(filteredChildArr);
            } else {
                bean.setCollection(false);
            }
            resource.discard();
            return bean;
        }
        catch (RegistryException e) {
            String msg = "Failed to get the resource information of resource " + resourcePath + " for constructing the resource tree entry. " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }
}

